/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509.extension;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class AuthorityKeyIdentifierStructure
extends AuthorityKeyIdentifier {
    private AuthorityKeyIdentifier authKeyID;

    public AuthorityKeyIdentifierStructure(byte[] byArray) throws IOException {
        super((ASN1Sequence)X509ExtensionUtil.fromExtensionValue(byArray));
    }

    private static ASN1Sequence fromCertificate(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(x509Certificate.getPublicKey().getEncoded()).readObject());
            GeneralName generalName = new GeneralName(PrincipalUtil.getSubjectX509Principal(x509Certificate));
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(generalName);
            return (ASN1Sequence)new AuthorityKeyIdentifier(subjectPublicKeyInfo, new GeneralNames(new DERSequence(aSN1EncodableVector)), x509Certificate.getSerialNumber()).toASN1Object();
        }
        catch (Exception exception) {
            throw new CertificateParsingException("Exception extracting certificate details: " + exception.toString());
        }
    }

    private static ASN1Sequence fromKey(PublicKey publicKey) throws InvalidKeyException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(publicKey.getEncoded()).readObject());
            return (ASN1Sequence)new AuthorityKeyIdentifier(subjectPublicKeyInfo).toASN1Object();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("can't process key: " + exception);
        }
    }

    public AuthorityKeyIdentifierStructure(X509Certificate x509Certificate) throws CertificateParsingException {
        super(AuthorityKeyIdentifierStructure.fromCertificate(x509Certificate));
    }

    public AuthorityKeyIdentifierStructure(PublicKey publicKey) throws InvalidKeyException {
        super(AuthorityKeyIdentifierStructure.fromKey(publicKey));
    }
}

