/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class PEMWriter
extends BufferedWriter {
    public PEMWriter(Writer writer) {
        super(writer);
    }

    private void writeEncoded(byte[] byArray) throws IOException {
        char[] cArray = new char[64];
        byArray = Base64.encode(byArray);
        for (int i = 0; i < byArray.length; i += cArray.length) {
            int n;
            for (n = 0; n != cArray.length && i + n < byArray.length; ++n) {
                cArray[n] = (char)byArray[i + n];
            }
            this.write(cArray, 0, n);
            this.newLine();
        }
    }

    public void writeObject(Object object) throws IOException {
        byte[] byArray;
        String string;
        if (object instanceof X509Certificate) {
            string = "CERTIFICATE";
            try {
                byArray = ((X509Certificate)object).getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Cannot encode object: " + certificateEncodingException.toString());
            }
        } else if (object instanceof PrivateKey) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((Key)object).getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)aSN1InputStream.readObject());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            if (object instanceof RSAPrivateKey) {
                string = "RSA PRIVATE KEY";
                aSN1OutputStream.writeObject(privateKeyInfo.getPrivateKey());
            } else if (object instanceof DSAPrivateKey) {
                string = "DSA PRIVATE KEY";
                DSAParameter dSAParameter = DSAParameter.getInstance(privateKeyInfo.getAlgorithmId().getParameters());
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(new DERInteger(0));
                aSN1EncodableVector.add(new DERInteger(dSAParameter.getP()));
                aSN1EncodableVector.add(new DERInteger(dSAParameter.getQ()));
                aSN1EncodableVector.add(new DERInteger(dSAParameter.getG()));
                BigInteger bigInteger = ((DSAPrivateKey)object).getX();
                BigInteger bigInteger2 = dSAParameter.getG().modPow(bigInteger, dSAParameter.getP());
                aSN1EncodableVector.add(new DERInteger(bigInteger2));
                aSN1EncodableVector.add(new DERInteger(bigInteger));
                aSN1OutputStream.writeObject(new DERSequence(aSN1EncodableVector));
            } else {
                throw new IOException("Cannot identify private key");
            }
            byArray = byteArrayOutputStream.toByteArray();
        } else if (object instanceof X509AttributeCertificate) {
            string = "ATTRIBUTE CERTIFICATE";
            byArray = ((X509V2AttributeCertificate)object).getEncoded();
        } else if (object instanceof PKCS10CertificationRequest) {
            string = "CERTIFICATE REQUEST";
            byArray = ((PKCS10CertificationRequest)object).getEncoded();
        } else {
            throw new IOException("unknown object passed - can't encode.");
        }
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
        this.writeEncoded(byArray);
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

