/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.internet.MimeBodyPart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.test.CMSTestUtil;

public class SignedDataTest
extends TestCase {
    boolean DEBUG = true;
    MimeBodyPart msg;
    String signDN;
    KeyPair signKP;
    X509Certificate signCert;
    String origDN;
    KeyPair origKP;
    X509Certificate origCert;
    String reciDN;
    KeyPair reciKP;
    X509Certificate reciCert;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;

    public SignedDataTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(SignedDataTest.class);
    }

    public static Test suite() {
        return new TestSuite(SignedDataTest.class);
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
        try {
            this.signDN = "O=Bouncy Castle, C=AU";
            this.signKP = CMSTestUtil.makeKeyPair();
            this.signCert = CMSTestUtil.makeCertificate(this.signKP, this.signDN, this.signKP, this.signDN);
            this.origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            this.origKP = CMSTestUtil.makeKeyPair();
            this.origCert = CMSTestUtil.makeCertificate(this.origKP, this.origDN, this.signKP, this.signDN);
        }
        catch (Exception exception) {
            this.log(exception);
            SignedDataTest.fail();
        }
    }

    public void tearDown() {
    }

    public void testSHA1WithRSAEncapsulated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(this.origKP.getPrivate(), this.origCert, "1.3.14.3.2.26");
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SignedDataTest.fail();
        }
    }

    public void testSHA224WithRSAEncapsulated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(this.origKP.getPrivate(), this.origCert, CMSSignedDataGenerator.DIGEST_SHA224);
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SignedDataTest.fail();
        }
    }

    public void testSHA256WithRSAEncapsulated() {
        try {
            X509Certificate x509Certificate;
            Iterator<? extends Certificate> iterator;
            Collection<? extends Certificate> collection;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), "BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(this.origKP.getPrivate(), this.origCert, CMSSignedDataGenerator.DIGEST_SHA256);
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            cMSSignedDataGenerator.addCertificatesAndCRLs(cMSSignedData.getCertificatesAndCRLs("Collection", "BC"));
            cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
            cMSSignedData = CMSSignedData.replaceSigners(cMSSignedData, signerInformationStore);
            signerInformationStore = cMSSignedData.getSignerInfos();
            collection2 = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection2) {
                collection = certStore.getCertificates(signerInformation.getSID());
                iterator = collection.iterator();
                x509Certificate = (X509Certificate)iterator.next();
                SignedDataTest.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            SignedDataTest.fail();
        }
    }
}

