/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RC5Parameters;

public class RC532Engine
implements BlockCipher {
    private int _noRounds = 12;
    private int[] _S = null;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private boolean forEncryption;

    private int bytesToWord(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToWord(byArray, n);
        int n4 = this.bytesToWord(byArray, n + 4);
        int n5 = this._noRounds;
        while (n5 >= 1) {
            n4 = this.rotateRight(n4 - this._S[2 * n5 + 1], n3) ^ n3;
            n3 = this.rotateRight(n3 - this._S[2 * n5], n4) ^ n4;
            --n5;
        }
        this.wordToBytes(n3 - this._S[0], byArray2, n2);
        this.wordToBytes(n4 - this._S[1], byArray2, n2 + 4);
        return 8;
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToWord(byArray, n) + this._S[0];
        int n4 = this.bytesToWord(byArray, n + 4) + this._S[1];
        int n5 = 1;
        while (n5 <= this._noRounds) {
            n3 = this.rotateLeft(n3 ^ n4, n4) + this._S[2 * n5];
            n4 = this.rotateLeft(n4 ^ n3, n3) + this._S[2 * n5 + 1];
            ++n5;
        }
        this.wordToBytes(n3, byArray2, n2);
        this.wordToBytes(n4, byArray2, n2 + 4);
        return 8;
    }

    public String getAlgorithmName() {
        return "RC5-32";
    }

    public int getBlockSize() {
        return 8;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof RC5Parameters) {
            RC5Parameters rC5Parameters = (RC5Parameters)cipherParameters;
            this._noRounds = rC5Parameters.getRounds();
            this.setKey(rC5Parameters.getKey());
        } else if (cipherParameters instanceof KeyParameter) {
            KeyParameter keyParameter = (KeyParameter)cipherParameters;
            this.setKey(keyParameter.getKey());
        } else {
            throw new IllegalArgumentException("invalid parameter passed to RC532 init - " + cipherParameters.getClass().getName());
        }
        this.forEncryption = bl;
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    public void reset() {
    }

    private int rotateLeft(int n, int n2) {
        return n << (n2 & 0x1F) | n >>> 32 - (n2 & 0x1F);
    }

    private int rotateRight(int n, int n2) {
        return n >>> (n2 & 0x1F) | n << 32 - (n2 & 0x1F);
    }

    private void setKey(byte[] byArray) {
        int[] nArray = new int[(byArray.length + 3) / 4];
        int n = 0;
        while (n != byArray.length) {
            int n2 = n / 4;
            nArray[n2] = nArray[n2] + ((byArray[n] & 0xFF) << 8 * (n % 4));
            ++n;
        }
        this._S = new int[2 * (this._noRounds + 1)];
        this._S[0] = -1209970333;
        int n3 = 1;
        while (n3 < this._S.length) {
            this._S[n3] = this._S[n3 - 1] + -1640531527;
            ++n3;
        }
        int n4 = nArray.length > this._S.length ? 3 * nArray.length : 3 * this._S.length;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            n5 = this._S[n7] = this.rotateLeft(this._S[n7] + n5 + n6, 3);
            n6 = nArray[n8] = this.rotateLeft(nArray[n8] + n5 + n6, n5 + n6);
            n7 = (n7 + 1) % this._S.length;
            n8 = (n8 + 1) % nArray.length;
            ++n9;
        }
    }

    private void wordToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 3] = (byte)(n >> 24);
    }
}

