/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.RIPEMD256Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class RIPEMD256DigestTest
implements Test {
    static final String[] messages = new String[]{"", "a", "abc", "message digest", "abcdefghijklmnopqrstuvwxyz", "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"};
    static final String[] digests = new String[]{"02ba4c4e5f8ecd1877fc52d64d30e37a2d9774fb1e5d026380ae0168e3c5522d", "f9333e45d857f5d90a91bab70a1eba0cfb1be4b0783c9acfcd883a9134692925", "afbd6e228b9d8cbbcef5ca2d03e6dba10ac0bc7dcbe4680e1e42d2e975459b65", "87e971759a1ce47a514d5c914c392c9018c7c46bc14465554afcdf54a5070c0e", "649d3034751ea216776bf9a18acc81bc7896118a5197968782dd1fd97d8d5133", "3843045583aac6c8c8d9128573e7a9809afb2a0f34ccc36ea9e72f16f6368e3f", "5740a408ac16b720b84424ae931cbb1fe363d1d0bf4017f1a89f7ea6de77a0b8", "06fdcc7a409548aaf91368c06a6275b553e3f099bf0ea4edfd6778df89a890dd"};
    static final String million_a_digest = "ac953744e10e31514c150d4d8d7b677342e33399788296e43ae4850ce4f97978";

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "RIPEMD256";
    }

    public TestResult perform() {
        byte[] byArray;
        RIPEMD256Digest rIPEMD256Digest = new RIPEMD256Digest();
        byte[] byArray2 = new byte[rIPEMD256Digest.getDigestSize()];
        int n = 0;
        while (n < messages.length) {
            byArray = messages[n].getBytes();
            rIPEMD256Digest.update(byArray, 0, byArray.length);
            rIPEMD256Digest.doFinal(byArray2, 0);
            if (!RIPEMD256DigestTest.arraysEqual(byArray2, Hex.decode((String)digests[n]))) {
                return new SimpleTestResult(false, this.getName() + ": Vector " + n + " failed");
            }
            ++n;
        }
        byArray = messages[messages.length - 1].getBytes();
        rIPEMD256Digest.update(byArray, 0, byArray.length / 2);
        RIPEMD256Digest rIPEMD256Digest2 = new RIPEMD256Digest(rIPEMD256Digest);
        rIPEMD256Digest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD256Digest.doFinal(byArray2, 0);
        if (!RIPEMD256DigestTest.arraysEqual(byArray2, Hex.decode((String)digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD256 failing clone test" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode((byte[])byArray2)));
        }
        rIPEMD256Digest2.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD256Digest2.doFinal(byArray2, 0);
        if (!RIPEMD256DigestTest.arraysEqual(byArray2, Hex.decode((String)digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD256 failing clone test - part 2" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode((byte[])byArray2)));
        }
        int n2 = 0;
        while (n2 < 1000000) {
            rIPEMD256Digest.update((byte)97);
            ++n2;
        }
        rIPEMD256Digest.doFinal(byArray2, 0);
        if (!RIPEMD256DigestTest.arraysEqual(byArray2, Hex.decode((String)million_a_digest))) {
            return new SimpleTestResult(false, this.getName() + ": Million a's failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        RIPEMD256DigestTest rIPEMD256DigestTest = new RIPEMD256DigestTest();
        TestResult testResult = rIPEMD256DigestTest.perform();
        System.out.println(testResult);
    }
}

