/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SHA224DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f";
    private static String testVec2 = "61";
    private static String resVec2 = "abd37534c7d9a2efb9465de931cd7055ffdb8879563ae98078d6d6d5";
    private static String testVec3 = "616263";
    private static String resVec3 = "23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7";
    private static String testVec4 = "6162636462636465636465666465666765666768666768696768696a68696a6b696a6b6c6a6b6c6d6b6c6d6e6c6d6e6f6d6e6f706e6f7071";
    private static String resVec4 = "75388b16512776cc5dba5da1fd890150b0c6455cb4f58b1952522525";
    private static String testVec5 = "61616161616161616161";
    private static String resVec5 = "20794655980c91d8bbb4c1ea97618a4bf03f42581948b2ee4ee7ad67";

    public String getName() {
        return "SHA224";
    }

    public TestResult perform() {
        SHA224Digest sHA224Digest = new SHA224Digest();
        byte[] byArray = new byte[sHA224Digest.getDigestSize()];
        sHA224Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode((byte[])byArray));
        if (!resVec1.equals(string)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byte[] byArray2 = Hex.decode((String)testVec2);
        sHA224Digest.update(byArray2, 0, byArray2.length);
        sHA224Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec3);
        sHA224Digest.update(byArray2, 0, byArray2.length);
        sHA224Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        sHA224Digest.update(byArray2, 0, byArray2.length);
        sHA224Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        sHA224Digest.update(byArray2, 0, byArray2.length / 2);
        SHA224Digest sHA224Digest2 = new SHA224Digest(sHA224Digest);
        sHA224Digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA224Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA224 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        sHA224Digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA224Digest2.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA224 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec5);
        int n = 0;
        while (n < 100000) {
            sHA224Digest.update(byArray2, 0, byArray2.length);
            ++n;
        }
        sHA224Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec5.equals(string)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec5 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        SHA224DigestTest sHA224DigestTest = new SHA224DigestTest();
        TestResult testResult = sHA224DigestTest.perform();
        System.out.println(testResult);
    }
}

