/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.util.encoders.Encoder;

public abstract class AbstractCoderTest
extends TestCase {
    private static final int[] SIZES_TO_CHECK = new int[]{64, 128, 1024, 1025, 1026, 2048, 2049, 2050, 4096, 4097, 4098, 8192, 8193, 8194};
    protected Encoder enc;
    private Random r;

    AbstractCoderTest(String string) {
        super(string);
    }

    private void addSpace(ByteArrayOutputStream byteArrayOutputStream) {
        do {
            switch (this.r.nextInt(3)) {
                case 0: {
                    byteArrayOutputStream.write(10);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(13);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(9);
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(32);
                    break;
                }
            }
        } while (this.r.nextBoolean());
    }

    private byte[] addWhitespace(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.addSpace(byteArrayOutputStream);
        int n = 0;
        while (n < byArray.length - 5) {
            byteArrayOutputStream.write(byArray, n, 1);
            if (this.r.nextInt(100) < 5) {
                this.addSpace(byteArrayOutputStream);
            }
            ++n;
        }
        int n2 = byArray.length - 5;
        while (n2 < byArray.length) {
            byteArrayOutputStream.write(byArray, n2, 1);
            ++n2;
        }
        this.addSpace(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void checkArrayOfSize(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.r.nextBytes(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.encode(byArray, 0, byArray.length, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        Assert.assertTrue((byArray2.length > byArray.length ? 1 : 0) != 0);
        Assert.assertTrue((byArray2.length <= byArray.length * 2 ? 1 : 0) != 0);
        this.checkEncoding(byArray2);
        this.checkSimpleDecode(byArray, byArray2);
        this.checkStringDecode(byArray, byArray2);
        this.checkOutputStreamDecode(byArray, byArray2);
        int n2 = this.r.nextInt(20);
        byte[] byArray3 = new byte[n2 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        this.checkOffsetDecode(byArray, byArray3, n2, byArray2.length);
        n2 = this.r.nextInt(20);
        byte[] byArray4 = new byte[n2 + byArray.length];
        System.arraycopy(byArray, 0, byArray4, n2, byArray.length);
        this.checkOffsetEncode(byArray, byArray4, n2, byArray.length);
        byte[] byArray5 = this.addWhitespace(byArray2);
        this.checkSimpleDecode(byArray, byArray5);
        this.checkStringDecode(byArray, byArray5);
        this.checkOutputStreamDecode(byArray, byArray5);
    }

    private void checkEncoding(byte[] byArray) {
        String string = this.convertBytesToString(byArray);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == this.paddingChar()) {
                Assert.assertTrue((n > string.length() - 3 ? 1 : 0) != 0);
            } else if (!this.isEncodedChar(c)) {
                Assert.fail((String)("Unexpected encoded character " + c));
            }
            ++n;
        }
    }

    private void checkOffsetDecode(byte[] byArray, byte[] byArray2, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.decode(byArray2, n, n2, byteArrayOutputStream);
        Assert.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private void checkOffsetEncode(byte[] byArray, byte[] byArray2, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.encode(byArray2, n, n2, byteArrayOutputStream);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        this.enc.decode(byArray3, 0, byArray3.length, byteArrayOutputStream);
        Assert.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private void checkOutputStreamDecode(byte[] byArray, byte[] byArray2) {
        String string = this.convertBytesToString(byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Assert.assertEquals((int)byArray.length, (int)this.enc.decode(string, byteArrayOutputStream));
            Assert.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            Assert.fail((String)"This shouldn't happen");
        }
    }

    private void checkSimpleDecode(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.decode(byArray2, 0, byArray2.length, byteArrayOutputStream);
        Assert.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private void checkStringDecode(byte[] byArray, byte[] byArray2) throws IOException {
        String string = this.convertBytesToString(byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.enc.decode(string, byteArrayOutputStream);
        Assert.assertTrue((boolean)Arrays.equals(byArray, byteArrayOutputStream.toByteArray()));
    }

    private String convertBytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n != byArray.length) {
            stringBuffer.append((char)(byArray[n] & 0xFF));
            ++n;
        }
        return stringBuffer.toString();
    }

    protected abstract boolean isEncodedChar(char var1);

    protected abstract char paddingChar();

    protected void setUp() {
        this.r = new Random();
    }

    public void testEncode() throws IOException {
        int n = 0;
        while (n < SIZES_TO_CHECK.length) {
            this.checkArrayOfSize(SIZES_TO_CHECK[n]);
            ++n;
        }
    }
}

