/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;

public class CMSSignedData {
    SignedData signedData;
    ContentInfo contentInfo;
    CMSProcessable signedContent;
    CertStore certStore;
    SignerInformationStore signerInfoStore;

    private static ContentInfo readContentInfo(InputStream inputStream) throws CMSException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
            return ContentInfo.getInstance((Object)aSN1InputStream.readObject());
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading content.", iOException);
        }
    }

    private CMSSignedData(CMSSignedData cMSSignedData) {
        this.signedData = cMSSignedData.signedData;
        this.contentInfo = cMSSignedData.contentInfo;
        this.signedContent = cMSSignedData.signedContent;
        this.certStore = cMSSignedData.certStore;
        this.signerInfoStore = cMSSignedData.signerInfoStore;
    }

    public CMSSignedData(byte[] byArray) throws CMSException {
        this(CMSSignedData.readContentInfo(new ByteArrayInputStream(byArray)));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, byte[] byArray) throws CMSException {
        this(cMSProcessable, CMSSignedData.readContentInfo(new ByteArrayInputStream(byArray)));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, InputStream inputStream) throws CMSException {
        this(cMSProcessable, CMSSignedData.readContentInfo(inputStream));
    }

    public CMSSignedData(InputStream inputStream) throws CMSException {
        this(CMSSignedData.readContentInfo(inputStream));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, ContentInfo contentInfo) {
        this.signedContent = cMSProcessable;
        this.contentInfo = contentInfo;
        this.signedData = SignedData.getInstance((Object)this.contentInfo.getContent());
    }

    public CMSSignedData(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        this.signedData = SignedData.getInstance((Object)this.contentInfo.getContent());
        this.signedContent = this.signedData.getEncapContentInfo().getContent() != null ? new CMSProcessableByteArray(((ASN1OctetString)this.signedData.getEncapContentInfo().getContent()).getOctets()) : null;
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set aSN1Set = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            int n = 0;
            while (n != aSN1Set.size()) {
                arrayList.add(new SignerInformation(SignerInfo.getInstance((Object)aSN1Set.getObjectAt(n)), this.signedData.getEncapContentInfo().getContentType(), this.signedContent));
                ++n;
            }
            this.signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this.signerInfoStore;
    }

    public CertStore getCertificatesAndCRLs(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (this.certStore == null) {
            Enumeration enumeration;
            CertificateFactory certificateFactory;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            try {
                certificateFactory = CertificateFactory.getInstance("X.509", string2);
            }
            catch (CertificateException certificateException) {
                throw new CMSException("can't get certificate factory.", certificateException);
            }
            ASN1Set aSN1Set = this.signedData.getCertificates();
            if (aSN1Set != null) {
                enumeration = aSN1Set.getObjects();
                while (enumeration.hasMoreElements()) {
                    try {
                        aSN1OutputStream.writeObject(enumeration.nextElement());
                        arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
                    }
                    catch (IOException iOException) {
                        throw new CMSException("can't re-encode certificate!", iOException);
                    }
                    catch (CertificateException certificateException) {
                        throw new CMSException("can't re-encode certificate!", certificateException);
                    }
                    byteArrayOutputStream.reset();
                }
            }
            if ((aSN1Set = this.signedData.getCRLs()) != null) {
                enumeration = aSN1Set.getObjects();
                while (enumeration.hasMoreElements()) {
                    try {
                        aSN1OutputStream.writeObject(enumeration.nextElement());
                        arrayList.add(certificateFactory.generateCRL(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
                    }
                    catch (IOException iOException) {
                        throw new CMSException("can't re-encode CRL!", iOException);
                    }
                    catch (CRLException cRLException) {
                        throw new CMSException("can't re-encode CRL!", cRLException);
                    }
                    byteArrayOutputStream.reset();
                }
            }
            try {
                this.certStore = CertStore.getInstance((String)string, (CertStoreParameters)new CollectionCertStoreParameters(arrayList), (String)string2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CMSException("can't setup the CertStore", invalidAlgorithmParameterException);
            }
        }
        return this.certStore;
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSProcessable getSignedContent() {
        return this.signedContent;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
        aSN1OutputStream.writeObject((Object)this.contentInfo);
        return byteArrayOutputStream.toByteArray();
    }

    public static CMSSignedData replaceSigners(CMSSignedData cMSSignedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        cMSSignedData2.signerInfoStore = signerInformationStore;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add((DEREncodable)((SignerInformation)iterator.next()).toSignerInfo());
        }
        DERSet dERSet = new DERSet((DEREncodableVector)aSN1EncodableVector);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)cMSSignedData.signedData.getDERObject();
        aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n != aSN1Sequence.size() - 1) {
            aSN1EncodableVector.add(aSN1Sequence.getObjectAt(n));
            ++n;
        }
        aSN1EncodableVector.add((DEREncodable)dERSet);
        cMSSignedData2.signedData = SignedData.getInstance((Object)new BERSequence((DEREncodableVector)aSN1EncodableVector));
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), (DEREncodable)cMSSignedData2.signedData);
        return cMSSignedData2;
    }
}

