/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.mail.smime.SMIMEException;

public class SMIMEUtil {
    public static MimeBodyPart toMimeBodyPart(byte[] byArray) throws SMIMEException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)byteArrayInputStream);
            return mimeBodyPart;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception creating body part.", (Exception)((Object)messagingException));
        }
    }

    public static IssuerAndSerialNumber createIssuerAndSerialNumberFor(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            return new IssuerAndSerialNumber((X509Name)PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate), x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            throw new CertificateParsingException("exception extracting issuer and serial number: " + exception);
        }
    }
}

