/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.CRC24;

public class ArmoredOutputStream
extends OutputStream {
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    OutputStream out;
    boolean oldPackets;
    int[] buf = new int[3];
    int bufPtr = 0;
    CRC24 crc = new CRC24();
    int chunkCount = 0;
    boolean start = true;
    boolean clearText = false;
    boolean newLine = false;
    String nl = System.getProperty("line.separator");
    String type;
    String headerStart = "-----BEGIN PGP ";
    String headerTail = "-----";
    String footerStart = "-----END PGP ";
    String footerTail = "-----";
    String version = "Version: BCPG v1.25";

    public ArmoredOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        if (this.nl == null) {
            this.nl = "\r\n";
        }
    }

    public void beginClearText(int n) throws IOException {
        String string;
        switch (n) {
            case 2: {
                string = "SHA1";
                break;
            }
            case 5: {
                string = "MD2";
                break;
            }
            case 1: {
                string = "MD5";
                break;
            }
            case 3: {
                string = "RIPEMD160";
                break;
            }
            default: {
                throw new IOException("unknown hash algorithm tag in beginClearText: " + n);
            }
        }
        String string2 = "-----BEGIN PGP SIGNED MESSAGE-----" + this.nl;
        String string3 = "Hash: " + string + this.nl + this.nl;
        int n2 = 0;
        while (n2 != string2.length()) {
            this.out.write(string2.charAt(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 != string3.length()) {
            this.out.write(string3.charAt(n3));
            ++n3;
        }
        this.clearText = true;
        this.newLine = true;
    }

    public void close() throws IOException {
        this.encode(this.out, this.buf, this.bufPtr);
        int n = 0;
        while (n != this.nl.length()) {
            this.out.write(this.nl.charAt(n));
            ++n;
        }
        this.out.write(61);
        int n2 = this.crc.getValue();
        this.buf[0] = n2 >> 16 & 0xFF;
        this.buf[1] = n2 >> 8 & 0xFF;
        this.buf[2] = n2 & 0xFF;
        this.encode(this.out, this.buf, 3);
        int n3 = 0;
        while (n3 != this.nl.length()) {
            this.out.write(this.nl.charAt(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 != this.footerStart.length()) {
            this.out.write(this.footerStart.charAt(n4));
            ++n4;
        }
        int n5 = 0;
        while (n5 != this.type.length()) {
            this.out.write(this.type.charAt(n5));
            ++n5;
        }
        int n6 = 0;
        while (n6 != this.footerTail.length()) {
            this.out.write(this.footerTail.charAt(n6));
            ++n6;
        }
        int n7 = 0;
        while (n7 != this.nl.length()) {
            this.out.write(this.nl.charAt(n7));
            ++n7;
        }
        this.out.flush();
    }

    private void encode(OutputStream outputStream, int[] nArray, int n) throws IOException {
        switch (n) {
            case 1: {
                int n2 = nArray[0];
                outputStream.write(encodingTable[n2 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[n2 << 4 & 0x3F]);
                outputStream.write(61);
                outputStream.write(61);
                break;
            }
            case 2: {
                int n3 = nArray[0];
                int n4 = nArray[1];
                outputStream.write(encodingTable[n3 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[(n3 << 4 | n4 >>> 4) & 0x3F]);
                outputStream.write(encodingTable[n4 << 2 & 0x3F]);
                outputStream.write(61);
                break;
            }
            case 3: {
                int n5 = nArray[0];
                int n6 = nArray[1];
                int n7 = nArray[2];
                outputStream.write(encodingTable[n5 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[(n5 << 4 | n6 >>> 4) & 0x3F]);
                outputStream.write(encodingTable[(n6 << 2 | n7 >>> 6) & 0x3F]);
                outputStream.write(encodingTable[n7 & 0x3F]);
                break;
            }
            default: {
                throw new IOException("unknown length in encode");
            }
            case 0: 
        }
    }

    public void endClearText() {
        this.clearText = false;
    }

    public void flush() throws IOException {
    }

    public void write(int n) throws IOException {
        int n2;
        if (this.clearText) {
            this.out.write(n);
            if (this.newLine) {
                this.newLine = false;
                if (n == 45) {
                    this.out.write(32);
                    this.out.write(45);
                }
            }
            if (n == 10) {
                this.newLine = true;
            }
            return;
        }
        if (this.start) {
            n2 = (n & 0x40) == 0 ? 0 : 1;
            int n3 = 0;
            n3 = n2 != 0 ? n & 0x3F : (n & 0x3F) >> 2;
            switch (n3) {
                case 6: {
                    this.type = "PUBLIC KEY BLOCK";
                    break;
                }
                case 5: {
                    this.type = "PRIVATE KEY BLOCK";
                    break;
                }
                case 2: {
                    this.type = "SIGNATURE";
                    break;
                }
                default: {
                    this.type = "MESSAGE";
                }
            }
            int n4 = 0;
            while (n4 != this.headerStart.length()) {
                this.out.write(this.headerStart.charAt(n4));
                ++n4;
            }
            int n5 = 0;
            while (n5 != this.type.length()) {
                this.out.write(this.type.charAt(n5));
                ++n5;
            }
            int n6 = 0;
            while (n6 != this.headerTail.length()) {
                this.out.write(this.headerTail.charAt(n6));
                ++n6;
            }
            int n7 = 0;
            while (n7 != this.nl.length()) {
                this.out.write(this.nl.charAt(n7));
                ++n7;
            }
            int n8 = 0;
            while (n8 != this.version.length()) {
                this.out.write(this.version.charAt(n8));
                ++n8;
            }
            int n9 = 0;
            while (n9 != this.nl.length()) {
                this.out.write(this.nl.charAt(n9));
                ++n9;
            }
            int n10 = 0;
            while (n10 != this.nl.length()) {
                this.out.write(this.nl.charAt(n10));
                ++n10;
            }
            this.start = false;
        }
        if (this.bufPtr == 3) {
            this.encode(this.out, this.buf, this.bufPtr);
            this.bufPtr = 0;
            if ((++this.chunkCount & 0xF) == 0) {
                n2 = 0;
                while (n2 != this.nl.length()) {
                    this.out.write(this.nl.charAt(n2));
                    ++n2;
                }
            }
        }
        this.crc.update(n);
        this.buf[this.bufPtr++] = n & 0xFF;
    }
}

