/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.security.PublicKey;
import org.bouncycastle.jce.cert.CertPathValidatorResult;
import org.bouncycastle.jce.cert.PolicyNode;
import org.bouncycastle.jce.cert.TrustAnchor;

public class PKIXCertPathValidatorResult
implements CertPathValidatorResult {
    private TrustAnchor trustAnchor;
    private PolicyNode policyTree;
    private PublicKey subjectPublicKey;

    public PKIXCertPathValidatorResult(TrustAnchor trustAnchor, PolicyNode policyNode, PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("subjectPublicKey must be non-null");
        }
        if (trustAnchor == null) {
            throw new NullPointerException("trustAnchor must be non-null");
        }
        this.trustAnchor = trustAnchor;
        this.policyTree = policyNode;
        this.subjectPublicKey = publicKey;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public PolicyNode getPolicyTree() {
        return this.policyTree;
    }

    public PublicKey getPublicKey() {
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        return this.trustAnchor;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKIXCertPathValidatorResult: [ \n");
        stringBuffer.append("  Trust Anchor: " + this.getTrustAnchor() + "\n");
        stringBuffer.append("  Policy Tree: " + this.getPolicyTree() + "\n");
        stringBuffer.append("  Subject Public Key: " + this.getPublicKey() + "\n]");
        return stringBuffer.toString();
    }
}

