/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class TigerDigestTest
implements Test {
    static final String[] messages = new String[]{"", "abc", "Tiger", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvw", "ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789", "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham, proceedings of Fast Software Encryption 3, Cambridge, 1996.", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-"};
    static final String[] digests = new String[]{"3293AC630C13F0245F92BBB1766E16167A4E58492DDE73F3", "2AAB1484E8C158F2BFB8C5FF41B57A525129131C957B5F93", "DD00230799F5009FEC6DEBC838BB6A27DF2B9D6F110C7937", "F71C8583902AFB879EDFE610F82C0D4786A3A534504486B5", "38F41D9D9A710A10C3727AC0DEEAA270727D9F926EC10139", "48CEEB6308B87D46E95D656112CDF18D97915F9765658957", "631ABDD103EB9A3D245B6DFD4D77B257FC7439501D1568DD", "C54034E5B43EB8005848A7E0AE6AAC76E4FF590AE715FD25", "C54034E5B43EB8005848A7E0AE6AAC76E4FF590AE715FD25"};
    static final String hash64k = "FDF4F5B35139F48E710E421BE5AF411DE1A8AAC333F26204";

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "Tiger";
    }

    public TestResult perform() {
        byte[] byArray;
        TigerDigest tigerDigest = new TigerDigest();
        byte[] byArray2 = new byte[tigerDigest.getDigestSize()];
        boolean bl = false;
        int n = 0;
        while (n < messages.length) {
            byArray = messages[n].getBytes();
            tigerDigest.update(byArray, 0, byArray.length);
            tigerDigest.doFinal(byArray2, 0);
            if (!TigerDigestTest.arraysEqual(byArray2, Hex.decode((String)digests[n]))) {
                return new SimpleTestResult(false, this.getName() + ": Vector " + n + " failed got " + new String(Hex.encode((byte[])byArray2)));
            }
            ++n;
        }
        byArray = messages[messages.length - 1].getBytes();
        tigerDigest.update(byArray, 0, byArray.length / 2);
        TigerDigest tigerDigest2 = new TigerDigest(tigerDigest);
        tigerDigest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        tigerDigest.doFinal(byArray2, 0);
        if (!TigerDigestTest.arraysEqual(byArray2, Hex.decode((String)digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "Tiger failing clone test" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode((byte[])byArray2)));
        }
        tigerDigest2.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        tigerDigest2.doFinal(byArray2, 0);
        if (!TigerDigestTest.arraysEqual(byArray2, Hex.decode((String)digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "Tiger failing clone test - part 2" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode((byte[])byArray2)));
        }
        int n2 = 0;
        while (n2 < 65536) {
            tigerDigest.update((byte)(n2 & 0xFF));
            ++n2;
        }
        tigerDigest.doFinal(byArray2, 0);
        if (!TigerDigestTest.arraysEqual(byArray2, Hex.decode((String)hash64k))) {
            return new SimpleTestResult(false, this.getName() + ": Million a's failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        TigerDigestTest tigerDigestTest = new TigerDigestTest();
        TestResult testResult = tigerDigestTest.perform();
        System.out.println(testResult);
    }
}

