/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.mail.smime.SMIMESigned;

public class ReadSignedMail {
    private static void verify(SMIMESigned sMIMESigned) throws Exception {
        CertStore certStore = sMIMESigned.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection collection2;
            Iterator iterator2;
            X509Certificate x509Certificate;
            SignerInformation signerInformation = (SignerInformation)iterator.next();
            if (signerInformation.verify(x509Certificate = (X509Certificate)(iterator2 = (collection2 = certStore.getCertificates((CertSelector)signerInformation.getSID())).iterator()).next(), "BC")) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new FileInputStream("signed.message"));
        if (mimeMessage.isMimeType("multipart/signed")) {
            SMIMESigned sMIMESigned = new SMIMESigned((MimeMultipart)mimeMessage.getContent());
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            } else if (object instanceof Multipart) {
                Multipart multipart = (Multipart)object;
                int n = multipart.getCount();
                int n2 = 0;
                while (n2 < n) {
                    BodyPart bodyPart = multipart.getBodyPart(n2);
                    Object object2 = bodyPart.getContent();
                    System.out.println("Part " + n2);
                    System.out.println("---------------------------");
                    if (object2 instanceof String) {
                        System.out.println((String)object2);
                    } else {
                        System.out.println("can't print...");
                    }
                    ++n2;
                }
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else if (mimeMessage.isMimeType("application/pkcs7-mime")) {
            SMIMESigned sMIMESigned = new SMIMESigned((Part)mimeMessage);
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

