/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPV3SignatureGenerator {
    private int keyAlgorithm;
    private int hashAlgorithm;
    private PGPPrivateKey privKey;
    private Signature sig;
    private MessageDigest dig;
    private int signatureType;

    public PGPV3SignatureGenerator(int n, int n2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
        this.dig = MessageDigest.getInstance(PGPUtil.getDigestName(n2), string);
        this.sig = Signature.getInstance(PGPUtil.getSignatureName(n, n2), string);
    }

    public void initSign(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.privKey = pGPPrivateKey;
        this.signatureType = n;
        try {
            this.sig.initSign(pGPPrivateKey.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
        this.dig.reset();
    }

    public void update(byte by) throws SignatureException {
        if (this.signatureType == 1) {
            if (by == 10) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
                this.dig.update((byte)13);
                this.dig.update((byte)10);
                return;
            }
            if (by == 13) {
                return;
            }
        }
        this.sig.update(by);
        this.dig.update(by);
    }

    public void update(byte[] byArray) throws SignatureException {
        if (this.signatureType == 1) {
            for (int i = 0; i != byArray.length; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.sig.update(byArray);
            this.dig.update(byArray);
        }
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.sig.update(byArray, n, n2);
            this.dig.update(byArray, n, n2);
        }
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.signatureType, this.hashAlgorithm, this.keyAlgorithm, this.privKey.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        Object object;
        Object object2;
        MPInteger[] mPIntegerArray;
        long l = new Date().getTime() / 1000L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.signatureType);
        byteArrayOutputStream.write((byte)(l >> 24));
        byteArrayOutputStream.write((byte)(l >> 16));
        byteArrayOutputStream.write((byte)(l >> 8));
        byteArrayOutputStream.write((byte)l);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.update(byArray);
        if (this.keyAlgorithm == 3 || this.keyAlgorithm == 1) {
            mPIntegerArray = new MPInteger[]{new MPInteger(new BigInteger(1, this.sig.sign()))};
        } else {
            DERInteger dERInteger;
            object2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.sig.sign()));
            try {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)object2.readObject();
                object = (DERInteger)aSN1Sequence.getObjectAt(0);
                dERInteger = (DERInteger)aSN1Sequence.getObjectAt(1);
            }
            catch (IOException iOException) {
                throw new PGPException("exception encoding signature", iOException);
            }
            mPIntegerArray = new MPInteger[]{new MPInteger(object.getValue()), new MPInteger(dERInteger.getValue())};
        }
        object2 = this.dig.digest();
        object = new byte[2];
        object[0] = object2[0];
        object[1] = object2[1];
        return new PGPSignature(new SignaturePacket(3, this.signatureType, this.privKey.getKeyID(), this.keyAlgorithm, this.hashAlgorithm, l * 1000L, (byte[])object, mPIntegerArray));
    }
}

