/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        CertPathValidator certPathValidator;
        CertificateFactory certificateFactory;
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXBuilderParameters instance");
        }
        PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        CertPath certPath = null;
        GeneralSecurityException generalSecurityException = null;
        CertSelector certSelector = pKIXBuilderParameters.getTargetCertConstraints();
        if (certSelector == null) {
            throw new CertPathBuilderException("targetCertConstraints must be non-null for CertPath building");
        }
        Collection collection = this.findCertificates(certSelector, pKIXBuilderParameters.getCertStores());
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("no certificate found matching targetCertContraints");
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("exception creating support classes: " + exception);
        }
        for (Object object : collection) {
            arrayList.clear();
            while (object != null) {
                Object object2;
                arrayList.add((X509Certificate)object);
                if (this.findTrustAnchor((X509Certificate)object, pKIXBuilderParameters.getTrustAnchors()) != null) {
                    try {
                        certPath = certificateFactory.generateCertPath(arrayList);
                        object2 = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
                        return new PKIXCertPathBuilderResult(certPath, ((PKIXCertPathValidatorResult)object2).getTrustAnchor(), ((PKIXCertPathValidatorResult)object2).getPolicyTree(), ((PKIXCertPathValidatorResult)object2).getPublicKey());
                    }
                    catch (CertificateException certificateException) {
                        generalSecurityException = certificateException;
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        generalSecurityException = certPathValidatorException;
                    }
                    object = null;
                    continue;
                }
                try {
                    object2 = this.findIssuer((X509Certificate)object, pKIXBuilderParameters.getCertStores());
                    if (((Certificate)object2).equals(object)) {
                        object = null;
                        continue;
                    }
                    object = object2;
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    generalSecurityException = certPathValidatorException;
                    object = null;
                }
            }
        }
        if (certPath != null) {
            throw new CertPathBuilderException("found certificate chain, but could not be validated", generalSecurityException);
        }
        throw new CertPathBuilderException("unable to find certificate chain");
    }

    final TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set set) throws CertPathBuilderException {
        Iterator iterator = set.iterator();
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new CertPathBuilderException("can't get trust anchor principal", null);
        }
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
                        X500Principal x500Principal2 = new X500Principal(trustAnchor.getCAName());
                        if (x500Principal.equals(x500Principal2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new CertPathBuilderException("TrustAnchor found put certificate validation failed", exception);
        }
        return trustAnchor;
    }

    private final Collection findCertificates(CertSelector certSelector, List list) {
        HashSet<? extends Certificate> hashSet = new HashSet<Certificate>();
        for (CertStore certStore : list) {
            try {
                hashSet.addAll(certStore.getCertificates(certSelector));
            }
            catch (CertStoreException certStoreException) {
                certStoreException.printStackTrace();
            }
        }
        return hashSet;
    }

    private final X509Certificate findIssuer(X509Certificate x509Certificate, List list) throws CertPathValidatorException {
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        Iterator iterator = this.findCertificates(x509CertSelector, list).iterator();
        X509Certificate x509Certificate2 = null;
        while (iterator.hasNext() && x509Certificate2 == null) {
            x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            catch (Exception exception2) {
                exception = exception2;
                x509Certificate2 = null;
            }
        }
        if (x509Certificate2 == null && exception == null) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        if (x509Certificate2 == null && exception != null) {
            throw new CertPathValidatorException("issuer found but certificate validation failed", (Throwable)exception, null, -1);
        }
        return x509Certificate2;
    }
}

