/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class OCSPTestUtil {
    public static SecureRandom rand;
    public static KeyPairGenerator kpg;
    public static KeyGenerator desede128kg;
    public static KeyGenerator desede192kg;
    public static KeyGenerator rc240kg;
    public static KeyGenerator rc264kg;
    public static KeyGenerator rc2128kg;
    public static BigInteger serialNumber;
    public static final boolean DEBUG = true;

    public static KeyPair makeKeyPair() {
        return kpg.generateKeyPair();
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, false);
    }

    public static X509Certificate makeCACertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(keyPair, string, keyPair2, string2, true);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, boolean bl) throws GeneralSecurityException, IOException {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair2.getPrivate();
        PublicKey publicKey2 = keyPair2.getPublic();
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.reset();
        x509V3CertificateGenerator.setSerialNumber(OCSPTestUtil.allocateSerialNumber());
        x509V3CertificateGenerator.setIssuerDN(new X509Name(string2));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis()));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        x509V3CertificateGenerator.setSubjectDN(new X509Name(string));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)OCSPTestUtil.createSubjectKeyId(publicKey));
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)OCSPTestUtil.createAuthorityKeyId(publicKey2));
        x509V3CertificateGenerator.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(bl));
        X509Certificate x509Certificate = x509V3CertificateGenerator.generateX509Certificate(privateKey);
        x509Certificate.checkValidity(new Date());
        x509Certificate.verify(publicKey2);
        return x509Certificate;
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey, X509Name x509Name, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        GeneralName generalName = new GeneralName(x509Name);
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo, new GeneralNames(new DERSequence(generalName)), BigInteger.valueOf(n));
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(byteArrayInputStream).readObject());
        return new SubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    private static BigInteger allocateSerialNumber() {
        BigInteger bigInteger = serialNumber;
        serialNumber = serialNumber.add(BigInteger.ONE);
        return bigInteger;
    }

    public static void log(Exception exception) {
        exception.printStackTrace();
    }

    public static void log(String string) {
        System.out.println(string);
    }

    static {
        try {
            rand = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(1024, rand);
            serialNumber = new BigInteger("1");
        }
        catch (Exception exception) {
            OCSPTestUtil.log(exception);
        }
    }
}

