/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.ECGOST3410Signer;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class ECGOST3410Test
implements Test {
    byte[] hashmessage = Hex.decode((String)"3042453136414534424341374533364339313734453431443642453241453435");
    Test[] tests = new Test[]{new ECGOST3410_TEST(), new ECGOST3410_TestParam(), new ECGOST3410_AParam(), new ECGOST3410_BParam(), new ECGOST3410_CParam()};

    public String getName() {
        return "ECGOST3410";
    }

    public TestResult perform() {
        for (int i = 0; i != this.tests.length; ++i) {
            TestResult testResult = this.tests[i].perform();
            if (testResult.isSuccessful()) continue;
            return testResult;
        }
        return new SimpleTestResult(true, "ECGOST3410: Okay");
    }

    public static void main(String[] stringArray) {
        ECGOST3410Test eCGOST3410Test = new ECGOST3410Test();
        TestResult testResult = eCGOST3410Test.perform();
        System.out.println(testResult);
    }

    private class ECGOST3410_CParam
    implements Test {
        private ECGOST3410_CParam() {
        }

        public String getName() {
            return "ECGOST3410 with  CryptoPro-C parameters.";
        }

        public TestResult perform() {
            SecureRandom secureRandom = new SecureRandom();
            BigInteger bigInteger = new BigInteger("70390085352083305199547718019018437841079516630045180471284346843705633502619");
            ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("70390085352083305199547718019018437841079516630045180471284346843705633502616"), new BigInteger("32858"));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, (ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("0")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("29818893917731240733471273240314769927240550812383695689146495261604565990247"))), new BigInteger("70390085352083305199547718019018437840920882647164081035322601458352298396601"));
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), secureRandom);
            ECGOST3410Signer eCGOST3410Signer = new ECGOST3410Signer();
            eCGOST3410Signer.init(true, (CipherParameters)parametersWithRandom);
            BigInteger[] bigIntegerArray = eCGOST3410Signer.generateSignature(ECGOST3410Test.this.hashmessage);
            eCGOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (eCGOST3410Signer.verifySignature(ECGOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": signature fails");
        }
    }

    private class ECGOST3410_BParam
    implements Test {
        private ECGOST3410_BParam() {
        }

        public String getName() {
            return "ECGOST3410 with  CryptoPro-B parameters.";
        }

        public TestResult perform() {
            SecureRandom secureRandom = new SecureRandom();
            BigInteger bigInteger = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564823193");
            ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564823190"), new BigInteger("28091019353058090096996979000309560759124368558014865957655842872397301267595"));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, (ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("1")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("28792665814854611296992347458380284135028636778229113005756334730996303888124"))), new BigInteger("57896044618658097711785492504343953927102133160255826820068844496087732066703"));
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), secureRandom);
            ECGOST3410Signer eCGOST3410Signer = new ECGOST3410Signer();
            eCGOST3410Signer.init(true, (CipherParameters)parametersWithRandom);
            BigInteger[] bigIntegerArray = eCGOST3410Signer.generateSignature(ECGOST3410Test.this.hashmessage);
            eCGOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (eCGOST3410Signer.verifySignature(ECGOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": signature fails");
        }
    }

    private class ECGOST3410_AParam
    implements Test {
        private ECGOST3410_AParam() {
        }

        public String getName() {
            return "ECGOST3410 with  CryptoPro-A parameters.";
        }

        public TestResult perform() {
            SecureRandom secureRandom = new SecureRandom();
            BigInteger bigInteger = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639319");
            ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639316"), new BigInteger("166"));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, (ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("1")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("64033881142927202683649881450433473985931760268884941288852745803908878638612"))), new BigInteger("115792089237316195423570985008687907853073762908499243225378155805079068850323"));
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), secureRandom);
            ECGOST3410Signer eCGOST3410Signer = new ECGOST3410Signer();
            eCGOST3410Signer.init(true, (CipherParameters)parametersWithRandom);
            BigInteger[] bigIntegerArray = eCGOST3410Signer.generateSignature(ECGOST3410Test.this.hashmessage);
            eCGOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (eCGOST3410Signer.verifySignature(ECGOST3410Test.this.hashmessage, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": signature fails");
        }
    }

    private class ECGOST3410_TestParam
    implements Test {
        private ECGOST3410_TestParam() {
        }

        public String getName() {
            return "ECGOST3410 with test parameters.";
        }

        public TestResult perform() {
            SecureRandom secureRandom = new SecureRandom();
            BigInteger bigInteger = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
            ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, (ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("2")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), secureRandom);
            ECGOST3410Signer eCGOST3410Signer = new ECGOST3410Signer();
            eCGOST3410Signer.init(true, (CipherParameters)parametersWithRandom);
            byte[] byArray = "Message for sign".getBytes();
            GOST3411Digest gOST3411Digest = new GOST3411Digest();
            gOST3411Digest.update(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[gOST3411Digest.getDigestSize()];
            gOST3411Digest.doFinal(byArray2, 0);
            BigInteger[] bigIntegerArray = eCGOST3410Signer.generateSignature(byArray2);
            eCGOST3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
            if (eCGOST3410Signer.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": signature fails");
        }
    }

    private class ECGOST3410_TEST
    implements Test {
        BigInteger r = new BigInteger("29700980915817952874371204983938256990422752107994319651632687982059210933395");
        BigInteger s = new BigInteger("574973400270084654178925310019147038455227042649098563933718999175515839552");
        SecureRandom k = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = new BigInteger("53854137677348463731403841147996619241504003434302020712960838528893196233395").toByteArray();
                System.arraycopy(byArray2, byArray2.length - byArray.length, byArray, 0, byArray.length);
            }
        };

        private ECGOST3410_TEST() {
        }

        public String getName() {
            return "ECGOST3410 - TEST";
        }

        public TestResult perform() {
            BigInteger bigInteger = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
            ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, (ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("2")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
            ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("55441196065363246126355624130324183196576709222340016572108097750006097525544"), eCDomainParameters);
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)eCPrivateKeyParameters, this.k);
            ECGOST3410Signer eCGOST3410Signer = new ECGOST3410Signer();
            eCGOST3410Signer.init(true, (CipherParameters)parametersWithRandom);
            byte[] byArray = new BigInteger("20798893674476452017134061561508270130637142515379653289952617252661468872421").toByteArray();
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i != byArray.length; ++i) {
                byArray2[i] = byArray[byArray.length - 1 - i];
            }
            BigInteger[] bigIntegerArray = eCGOST3410Signer.generateSignature(byArray2);
            if (!this.r.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + this.r + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
            }
            if (!this.s.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + this.s + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
            }
            ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters((ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("57520216126176808443631405023338071176630104906313632182896741342206604859403")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("17614944419213781543809391949654080031942662045363639260709847859438286763994"))), eCDomainParameters);
            eCGOST3410Signer.init(false, (CipherParameters)eCPublicKeyParameters);
            if (eCGOST3410Signer.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": verification fails");
        }
    }
}

