/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SetTest
implements Test {
    public String getName() {
        return "Set";
    }

    public static void main(String[] stringArray) {
        SetTest setTest = new SetTest();
        TestResult testResult = setTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            byte[] byArray = new byte[10];
            aSN1EncodableVector.add((DEREncodable)new DEROctetString(byArray));
            aSN1EncodableVector.add((DEREncodable)new DERBitString(byArray));
            aSN1EncodableVector.add((DEREncodable)new DERInteger(100));
            aSN1EncodableVector.add((DEREncodable)new DERBoolean(true));
            DERSet dERSet = new DERSet((DEREncodableVector)aSN1EncodableVector);
            if (!(dERSet.getObjectAt(0) instanceof DERBoolean)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": sorting failed.");
            }
            DERTaggedObject dERTaggedObject = new DERTaggedObject(false, 1, (DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector));
            dERSet = ASN1Set.getInstance((ASN1TaggedObject)dERTaggedObject, (boolean)false);
            if (dERSet.getObjectAt(0) instanceof DERBoolean) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": sorted when shouldn't be.");
            }
            aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((DEREncodable)new DERBoolean(true));
            aSN1EncodableVector.add((DEREncodable)new DERBoolean(true));
            aSN1EncodableVector.add((DEREncodable)new DERBoolean(true));
            dERSet = new DERSet((DEREncodableVector)aSN1EncodableVector);
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Exception - " + exception.toString(), exception);
        }
    }
}

