/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.SkipjackEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CTSTest
implements Test {
    static byte[] in1 = Hex.decode((String)"4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode((String)"000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode((String)"9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode((String)"358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode((String)"170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    CTSTest() {
    }

    public String getName() {
        return "CTS";
    }

    public static void main(String[] stringArray) {
        CTSTest cTSTest = new CTSTest();
        TestResult testResult = cTSTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        byte[] byArray = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};
        byte[] byArray2 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -18, -1};
        byte[] byArray3 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        CTSTester cTSTester = new CTSTester(1, (BlockCipher)new DESEngine(), (CipherParameters)new KeyParameter(byArray), in1, out1);
        TestResult testResult = cTSTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        cTSTester = new CTSTester(2, (BlockCipher)new CBCBlockCipher((BlockCipher)new DESEngine()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(byArray), byArray3), in1, out2);
        testResult = cTSTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        cTSTester = new CTSTester(3, (BlockCipher)new CBCBlockCipher((BlockCipher)new SkipjackEngine()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(byArray2), byArray3), in2, out3);
        testResult = cTSTester.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    private class CTSTester
    implements Test {
        private int id;
        private BlockCipher cipher;
        private CipherParameters params;
        private byte[] input;
        private byte[] output;

        CTSTester(int n, BlockCipher blockCipher, CipherParameters cipherParameters, byte[] byArray, byte[] byArray2) {
            this.id = n;
            this.cipher = blockCipher;
            this.params = cipherParameters;
            this.input = byArray;
            this.output = byArray2;
        }

        public String getName() {
            return "CTSTest " + this.id;
        }

        public TestResult perform() {
            byte[] byArray = new byte[this.input.length];
            CTSBlockCipher cTSBlockCipher = new CTSBlockCipher(this.cipher);
            cTSBlockCipher.init(true, this.params);
            int n = cTSBlockCipher.processBytes(this.input, 0, this.input.length, byArray, 0);
            try {
                cTSBlockCipher.doFinal(byArray, n);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": encryption exception - " + exception.toString());
            }
            int n2 = 0;
            while (n2 != this.output.length) {
                if (byArray[n2] != this.output[n2]) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed encryption expected " + new String(Hex.encode((byte[])this.output)) + " got " + new String(Hex.encode((byte[])byArray)));
                }
                ++n2;
            }
            cTSBlockCipher.init(false, this.params);
            n = cTSBlockCipher.processBytes(this.output, 0, this.output.length, byArray, 0);
            try {
                cTSBlockCipher.doFinal(byArray, n);
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": decryption exception - " + exception.toString());
            }
            int n3 = 0;
            while (n3 != this.input.length) {
                if (byArray[n3] != this.input[n3]) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed encryption expected " + new String(Hex.encode((byte[])this.input)) + " got " + new String(Hex.encode((byte[])byArray)));
                }
                ++n3;
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
    }
}

