/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Provider;
import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MacTest
implements Test {
    static byte[] keyBytes = Hex.decode((String)"0123456789abcdef");
    static byte[] ivBytes = Hex.decode((String)"1234567890abcdef");
    static byte[] input = Hex.decode((String)"37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode((String)"f1d30f68");
    static byte[] output2 = Hex.decode((String)"58d2e77e");
    static byte[] output3 = Hex.decode((String)"cd647403");

    private boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        MacTest macTest = new MacTest();
        TestResult testResult = macTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        Mac mac;
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "DES");
        try {
            mac = Mac.getInstance("DESMac", "BC");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString());
        }
        try {
            mac.init(secretKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString());
        }
        mac.update(input, 0, input.length);
        byte[] byArray = mac.doFinal();
        if (!this.arraysEqual(byArray, output1)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - expected " + new String(Hex.encode((byte[])output1)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        try {
            mac.init(secretKeySpec, new IvParameterSpec(ivBytes));
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString());
        }
        mac.update(input, 0, input.length);
        byArray = mac.doFinal();
        if (!this.arraysEqual(byArray, output2)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - expected " + new String(Hex.encode((byte[])output2)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        try {
            mac = Mac.getInstance("DESMac/CFB8", "BC");
            mac.init(secretKeySpec, new IvParameterSpec(ivBytes));
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString());
        }
        mac.update(input, 0, input.length);
        byArray = mac.doFinal();
        if (!this.arraysEqual(byArray, output3)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - expected " + new String(Hex.encode((byte[])output3)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

