/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.CompressedData;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CMSTest
implements Test {
    byte[] compData = Base64.decode((String)"MIAGCyqGSIb3DQEJEAEJoIAwgAIBADANBgsqhkiG9w0BCRADCDCABgkqhkiG9w0BBwGggCSABIICHnic7ZRdb9owFIbvK/k/5PqVYPFXGK12YYyboVFASSp1vQtZGiLRACZE49/XHoUW7S/0tXP8EfuxfU5ivWnasml72XFb3gb5druui7ytN803M570nii7C5r8tfwR281hy/p/KSM3+jzH5s3+pbQ90xSbP3VT3QbLusnt8WPIuN5vN/vaA2+DulnXTXkXvNTr8j8ouZmkCmGI/UW+ZS/C8zP0bz2dz0zwLt+1UEk2M8mlaxjRMByAhZTj0RGYg4TvogiRASROsZgjpVcJCb1KV6QzQeDJ1XkoQ5Jm+C5PbOHZZGRiv+ORAcshOGeCcdFJyfgFxdtCdEcmOrbinc/+BBMzRThEYpwl+jEBpciSGWQkI0TSlREmD/eOHb2DSGLuESm/iKUFt1y4XHBO2a5oq0IKJKWLS9kUZTA7vC5LSxYmgVL46SIWxIfWBQd6AdrnjLmH94UTvGxVibLqRCtIpp4g2qpdtqK1LiOeolpVK5wVQ5P7+QjZAlrh0cePYTx/gNZuB9Vhndtgujl9T/tgW9ogK+3rnmg3YWygnTuF5GDS+Q/jIVLnCcYZFc6Kk/+c80wKwZjwdZIqDYWRH68MuBQSXLgXYXj23CAaYOBNJMliTl0X7eV5DnoKIFSKYdj3cRpD/cK/JWTHJRe76MUXnfBW8m7Hd5zhQ4ri2NrVF/WL+kV1/3AGSlJ32bFPd2BsQD8uSzIx6lObkjdz95c0AAAAAAAAAAAAAAAA");
    byte[] envDataKeyTrns = Base64.decode((String)"MIAGCSqGSIb3DQEHA6CAMIACAQAxgcQwgcECAQAwKjAlMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMQswCQYDVQQGEwJBVQIBCjANBgkqhkiG9w0BAQEFAASBgC5vdGrBitQSGwifLf3KwPILjaB4WEXgT/IIO1KDzrsbItCJsMA0Smq2y0zptxT0pSRL6JRgNMxLk1ySnrIrvGiEPLMR1zjxlT8yQ6VLX+kEoK43ztd1aaLw0oBfrcXcLN7BEpZ1TIdjlBfXIOx1S88WY1MiYqJJFc3LMwRUaTEDMIAGCSqGSIb3DQEHATAdBglghkgBZQMEARYEEAfxLMWeaBOTTZQwUq0Y5FuggAQgwOJhL04rjSZCBCSOv5i5XpFfGsOdYSHSqwntGpFqCx4AAAAAAAAAAAAA");
    byte[] envDataKEK = Base64.decode((String)"MIAGCSqGSIb3DQEHA6CAMIACAQIxVKJSMFACAQQwBwQFAQIDBAUwEAYLKoZIhvcNAQkQAwcCAToEMLsb8fJQ+KUiuKfZh5qOqaPv3lWgtYRNGdkAAVwCJB2hBbLP6gKHpZj8eMceL7TL5zCABgkqhkiG9w0BBwEwFAYIKoZIhvcNAwcECJjd4MEFsXqdoIAEGI13Mlv+/r5RkHddcqKnEUNSnP0bKPMH6AAAAAAAAAAAAAA=");
    byte[] signedData = Base64.decode((String)"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");

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private TestResult compressionTest() {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.compData));
            ContentInfo contentInfo = ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            CompressedData compressedData = CompressedData.getInstance((Object)contentInfo.getContent());
            compressedData = new CompressedData(compressedData.getCompressionAlgorithmIdentifier(), compressedData.getEncapContentInfo());
            contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, (DEREncodable)compressedData);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)contentInfo);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.compData)) {
                return new SimpleTestResult(false, this.getName() + ": CMS compression failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": CMS compression failed - " + exception.toString(), exception);
        }
    }

    private TestResult envelopedTest() {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.envDataKeyTrns));
            ContentInfo contentInfo = ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            EnvelopedData envelopedData = EnvelopedData.getInstance((Object)contentInfo.getContent());
            ASN1Set aSN1Set = envelopedData.getRecipientInfos();
            if (aSN1Set.size() != 1) {
                return new SimpleTestResult(false, this.getName() + ": CMS KeyTrans enveloped, wrong number of recipients");
            }
            RecipientInfo recipientInfo = RecipientInfo.getInstance((Object)aSN1Set.getObjectAt(0));
            if (!(recipientInfo.getInfo() instanceof KeyTransRecipientInfo)) {
                return new SimpleTestResult(false, this.getName() + ": CMS KeyTrans enveloped, wrong recipient type");
            }
            Object object = KeyTransRecipientInfo.getInstance((Object)recipientInfo.getInfo());
            object = new KeyTransRecipientInfo(object.getRecipientIdentifier(), object.getKeyEncryptionAlgorithm(), object.getEncryptedKey());
            aSN1Set = new DERSet((DEREncodable)new RecipientInfo((KeyTransRecipientInfo)object));
            object = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)object);
            envelopedData = new EnvelopedData(envelopedData.getOriginatorInfo(), aSN1Set, envelopedData.getEncryptedContentInfo(), envelopedData.getUnprotectedAttrs());
            contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, (DEREncodable)envelopedData);
            aSN1OutputStream.writeObject((Object)contentInfo);
            if (!this.isSameAs(((ByteArrayOutputStream)object).toByteArray(), this.envDataKeyTrns)) {
                return new SimpleTestResult(false, this.getName() + ": CMS KeyTrans enveloped failed to re-encode");
            }
            aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.envDataKEK));
            contentInfo = ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            envelopedData = EnvelopedData.getInstance((Object)contentInfo.getContent());
            aSN1Set = envelopedData.getRecipientInfos();
            if (aSN1Set.size() != 1) {
                return new SimpleTestResult(false, this.getName() + ": CMS KEK enveloped, wrong number of recipients");
            }
            recipientInfo = RecipientInfo.getInstance((Object)aSN1Set.getObjectAt(0));
            if (!(recipientInfo.getInfo() instanceof KEKRecipientInfo)) {
                return new SimpleTestResult(false, this.getName() + ": CMS KEK enveloped, wrong recipient type");
            }
            KEKRecipientInfo kEKRecipientInfo = KEKRecipientInfo.getInstance((Object)recipientInfo.getInfo());
            kEKRecipientInfo = new KEKRecipientInfo(kEKRecipientInfo.getKekid(), kEKRecipientInfo.getKeyEncryptionAlgorithm(), kEKRecipientInfo.getEncryptedKey());
            aSN1Set = new DERSet((DEREncodable)new RecipientInfo(kEKRecipientInfo));
            object = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream((OutputStream)object);
            envelopedData = new EnvelopedData(envelopedData.getOriginatorInfo(), aSN1Set, envelopedData.getEncryptedContentInfo(), envelopedData.getUnprotectedAttrs());
            contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, (DEREncodable)envelopedData);
            aSN1OutputStream.writeObject((Object)contentInfo);
            if (!this.isSameAs(((ByteArrayOutputStream)object).toByteArray(), this.envDataKEK)) {
                return new SimpleTestResult(false, this.getName() + ": CMS KEK enveloped failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": CMS enveloped failed - " + exception.toString(), exception);
        }
    }

    private TestResult signedTest() {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.signedData));
            ContentInfo contentInfo = ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            signedData = new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), signedData.getCertificates(), signedData.getCRLs(), signedData.getSignerInfos());
            contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (DEREncodable)signedData);
            aSN1OutputStream.writeObject((Object)contentInfo);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.signedData)) {
                return new SimpleTestResult(false, this.getName() + ": CMS signed failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": CMS signed failed - " + exception.toString(), exception);
        }
    }

    public TestResult perform() {
        TestResult testResult = this.compressionTest();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.envelopedTest();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return this.signedTest();
    }

    public String getName() {
        return "CMS";
    }

    public static void main(String[] stringArray) {
        CMSTest cMSTest = new CMSTest();
        TestResult testResult = cMSTest.perform();
        System.out.println(testResult);
    }
}

