/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class ECDSA5Test
implements Test {
    SecureRandom random = new SecureRandom(){
        boolean first = true;

        public void nextBytes(byte[] byArray) {
            byte[] byArray2 = Hex.decode((String)"d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
            byte[] byArray3 = Hex.decode((String)"345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
            if (this.first) {
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                this.first = false;
            } else {
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            }
        }
    };
    Test[] tests = new Test[]{new ECDSA239bitPrime(), new GenerationTest()};

    protected BigInteger[] derDecode(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        BigInteger[] bigIntegerArray = new BigInteger[]{((DERInteger)aSN1Sequence.getObjectAt(0)).getValue(), ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }

    public String getName() {
        return "ECDSA5";
    }

    public TestResult perform() {
        for (int i = 0; i != this.tests.length; ++i) {
            TestResult testResult = this.tests[i].perform();
            if (testResult.isSuccessful()) continue;
            return testResult;
        }
        return new SimpleTestResult(true, "ECDSA5: Okay");
    }

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ECDSA5Test eCDSA5Test = new ECDSA5Test();
        TestResult testResult = eCDSA5Test.perform();
        System.out.println(testResult.toString());
    }

    private class GenerationTest
    implements Test {
        private GenerationTest() {
        }

        public String getName() {
            return "EC/ECDSA Generation";
        }

        public TestResult perform() {
            try {
                byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
                Signature signature = Signature.getInstance("ECDSA", "BC");
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
                EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
                ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, ECPointUtil.decodePoint((EllipticCurve)ellipticCurve, (byte[])Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
                keyPairGenerator.initialize(eCParameterSpec, new SecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                signature.initSign(privateKey);
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature = Signature.getInstance("ECDSA", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": ECDSA verification failed");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class ECDSA239bitPrime
    implements Test {
        BigInteger r = new BigInteger("308636143175167811492622547300668018854959378758531778147462058306432176");
        BigInteger s = new BigInteger("323813553209797357708078776831250505931891051755007842781978505179448783");
        SecureRandom k = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = new BigInteger("700000017569056646655505781757157107570501575775705779575555657156756655").toByteArray();
                System.arraycopy(byArray2, byArray2.length - byArray.length, byArray, 0, byArray.length);
            }
        };

        private ECDSA239bitPrime() {
        }

        public String getName() {
            return "ECDSA5 239 bit prime";
        }

        public TestResult perform() {
            try {
                EllipticCurve ellipticCurve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
                ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, ECPointUtil.decodePoint((EllipticCurve)ellipticCurve, (byte[])Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
                ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("876300101507107567501066130761671078357010671067781776716671676178726717"), eCParameterSpec);
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(ECPointUtil.decodePoint((EllipticCurve)ellipticCurve, (byte[])Hex.decode((String)"025b6dc53bc61a2548ffb0f671472de6c9521a9d2d2534e65abfcbd5fe0c70")), eCParameterSpec);
                Signature signature = Signature.getInstance("ECDSA", "BC");
                KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
                PrivateKey privateKey = keyFactory.generatePrivate(eCPrivateKeySpec);
                PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
                signature.initSign(privateKey, this.k);
                byte[] byArray = new byte[]{97, 98, 99};
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": 239 Bit EC verification failed");
                }
                BigInteger[] bigIntegerArray = ECDSA5Test.this.derDecode(byArray2);
                if (!this.r.equals(bigIntegerArray[0])) {
                    return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + this.r + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
                }
                if (!this.s.equals(bigIntegerArray[1])) {
                    return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + this.s + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }
}

