/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.jce.provider.RSAUtil;
import org.bouncycastle.jce.provider.WrapCipherSpi;

public class JCERSACipher
extends WrapCipherSpi {
    private AsymmetricBlockCipher cipher;
    private boolean publicKeyOnly = false;
    private boolean privateKeyOnly = false;
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public JCERSACipher(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.cipher = asymmetricBlockCipher;
    }

    public JCERSACipher(boolean bl, boolean bl2, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.publicKeyOnly = bl;
        this.privateKeyOnly = bl2;
        this.cipher = asymmetricBlockCipher;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (byArray != null) {
            this.bOut.write(byArray, n, n2);
        }
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] byArray2 = this.bOut.toByteArray();
            this.bOut.reset();
            return this.cipher.processBlock(byArray2, 0, byArray2.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3;
        if (byArray != null) {
            this.bOut.write(byArray, n, n2);
        }
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        try {
            byte[] byArray4 = this.bOut.toByteArray();
            this.bOut.reset();
            byArray3 = this.cipher.processBlock(byArray4, 0, byArray4.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
        int n4 = 0;
        while (n4 != byArray3.length) {
            byArray2[n3 + n4] = byArray3[n4];
            ++n4;
        }
        return byArray3.length;
    }

    protected int engineGetBlockSize() {
        try {
            return this.cipher.getInputBlockSize();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
            return rSAPrivateKey.getModulus().bitLength();
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            return rSAPublicKey.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an RSA key!");
    }

    protected int engineGetOutputSize(int n) {
        try {
            return this.cipher.getOutputBlockSize();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("RSA Cipher not initialised");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("can't handle parameters in RSA");
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        if (algorithmParameterSpec != null) throw new IllegalArgumentException("unknown parameter type.");
        if (key instanceof RSAPublicKey) {
            if (this.privateKeyOnly) {
                throw new InvalidKeyException("mode 1 requires RSAPrivateKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)key);
        } else {
            if (!(key instanceof RSAPrivateKey)) throw new InvalidKeyException("unknown key type passed to RSA");
            if (this.publicKeyOnly) {
                throw new InvalidKeyException("mode 2 requires RSAPublicKey");
            }
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)key);
        }
        if (!(this.cipher instanceof RSAEngine)) {
            void var5_7;
            if (secureRandom != null) {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, secureRandom);
            } else {
                ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, new SecureRandom());
            }
        }
        switch (n) {
            case 1: 
            case 3: {
                void var5_10;
                this.cipher.init(true, (CipherParameters)var5_10);
                return;
            }
            case 2: 
            case 4: {
                void var5_10;
                this.cipher.init(false, (CipherParameters)var5_10);
                return;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    protected void engineSetMode(String string) {
        throw new IllegalArgumentException("can't support mode " + string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException(String.valueOf(string) + " unavailable with RSA.");
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.bOut.write(byArray, n, n2);
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.bOut.write(byArray, n, n2);
        if (this.cipher instanceof RSAEngine ? this.bOut.size() > this.cipher.getInputBlockSize() + 1 : this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
        return 0;
    }

    public static class NoPadding
    extends JCERSACipher {
        public NoPadding() {
            super(new RSAEngine());
        }
    }

    public static class PKCS1v1_5Padding
    extends JCERSACipher {
        public PKCS1v1_5Padding() {
            super(new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class PKCS1v1_5Padding_PrivateOnly
    extends JCERSACipher {
        public PKCS1v1_5Padding_PrivateOnly() {
            super(false, true, new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class PKCS1v1_5Padding_PublicOnly
    extends JCERSACipher {
        public PKCS1v1_5Padding_PublicOnly() {
            super(true, false, new PKCS1Encoding(new RSAEngine()));
        }
    }

    public static class OAEPPadding
    extends JCERSACipher {
        public OAEPPadding() {
            super(new OAEPEncoding(new RSAEngine()));
        }
    }

    public static class MD5OAEPPadding
    extends JCERSACipher {
        public MD5OAEPPadding() {
            super(new OAEPEncoding(new RSAEngine(), new MD5Digest()));
        }
    }

    public static class SHA224OAEPPadding
    extends JCERSACipher {
        public SHA224OAEPPadding() {
            super(new OAEPEncoding(new RSAEngine(), new SHA224Digest()));
        }
    }

    public static class SHA256OAEPPadding
    extends JCERSACipher {
        public SHA256OAEPPadding() {
            super(new OAEPEncoding(new RSAEngine(), new SHA256Digest()));
        }
    }

    public static class SHA384OAEPPadding
    extends JCERSACipher {
        public SHA384OAEPPadding() {
            super(new OAEPEncoding(new RSAEngine(), new SHA384Digest()));
        }
    }

    public static class SHA512OAEPPadding
    extends JCERSACipher {
        public SHA512OAEPPadding() {
            super(new OAEPEncoding(new RSAEngine(), new SHA512Digest()));
        }
    }

    public static class ISO9796d1Padding
    extends JCERSACipher {
        public ISO9796d1Padding() {
            super(new ISO9796d1Encoding(new RSAEngine()));
        }
    }
}

