/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    public KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, EncryptedContentInfo encryptedContentInfo) {
        super(AlgorithmIdentifier.getInstance((Object)kEKRecipientInfo.getKeyEncryptionAlgorithm()), encryptedContentInfo);
        this.info = kEKRecipientInfo;
        this.rid = new RecipientId();
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid.setKeyIdentifier(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    public byte[] getContent(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.info.getEncryptedKey().getOctets();
            Cipher cipher = Cipher.getInstance(this.keyEncAlg.getObjectId().getId(), string);
            cipher.init(4, key);
            byte[] byArray2 = this.data.getEncryptedContent().getOctets();
            AlgorithmIdentifier algorithmIdentifier = this.data.getContentEncryptionAlgorithm();
            String string2 = algorithmIdentifier.getObjectId().getId();
            Key key2 = cipher.unwrap(byArray, string2, 3);
            return this.getContentFromSessionKey(key2, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
    }
}

