package org.bouncycastle.crypto.params;

import java.security.SecureRandom;

import org.bouncycastle.crypto.KeyGenerationParameters;

public class DHKeyGenerationParameters
    extends KeyGenerationParameters
{
    private DHParameters    params;

    public DHKeyGenerationParameters(
        SecureRandom    random,
        DHParameters    params)
    {
        super(random, (params.getJ() != 0) ? params.getJ() : params.getP().bitLength() - 1);

        this.params = params;
    }

    public DHParameters getParameters()
    {
        return params;
    }
}
