/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;

public class SecretKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private PublicKeyPacket pubKeyPacket;
    private byte[] secKeyData;
    private int stringToKey;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] iv;

    SecretKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.pubKeyPacket = new PublicKeyPacket(bCPGInputStream);
        this.stringToKey = bCPGInputStream.read();
        if (this.stringToKey == 255 || this.stringToKey == 254) {
            this.encAlgorithm = bCPGInputStream.read();
            this.s2k = new S2K(bCPGInputStream);
        } else {
            this.encAlgorithm = this.stringToKey;
        }
        if ((this.s2k == null || this.s2k.getType() != 101 || this.s2k.getProtectionMode() != 1) && this.stringToKey != 0) {
            this.iv = this.encAlgorithm < 7 ? new byte[8] : new byte[16];
            bCPGInputStream.readFully(this.iv, 0, this.iv.length);
        }
        if (bCPGInputStream.available() != 0) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bCPGInputStream.available());
            while ((n = bCPGInputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            this.secKeyData = byteArrayOutputStream.toByteArray();
        }
    }

    public SecretKeyPacket(PublicKeyPacket publicKeyPacket, int n, S2K s2K, byte[] byArray, byte[] byArray2) {
        this.pubKeyPacket = publicKeyPacket;
        this.encAlgorithm = n;
        this.stringToKey = n != 0 ? 255 : 0;
        this.s2k = s2K;
        this.iv = byArray;
        this.secKeyData = byArray2;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(5, this.getEncodedContents(), true);
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream.write(this.pubKeyPacket.getEncodedContents());
        bCPGOutputStream.write(this.stringToKey);
        if (this.stringToKey == 255 || this.stringToKey == 254) {
            bCPGOutputStream.write(this.encAlgorithm);
            bCPGOutputStream.writeObject(this.s2k);
        }
        if (this.iv != null) {
            bCPGOutputStream.write(this.iv);
        }
        if (this.secKeyData != null) {
            bCPGOutputStream.write(this.secKeyData);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getIV() {
        return this.iv;
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.pubKeyPacket;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] getSecretKeyData() {
        return this.secKeyData;
    }
}

