/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;

public class PGPKeyPair {
    PGPPublicKey pub;
    PGPPrivateKey priv;

    public PGPKeyPair(int n, KeyPair keyPair, Date date, String string) throws PGPException, NoSuchProviderException {
        this(n, keyPair.getPublic(), keyPair.getPrivate(), date, string);
    }

    public PGPKeyPair(int n, PublicKey publicKey, PrivateKey privateKey, Date date, String string) throws PGPException, NoSuchProviderException {
        this.pub = new PGPPublicKey(n, publicKey, date, string);
        this.priv = new PGPPrivateKey(privateKey, this.pub.getKeyID());
    }

    public PGPKeyPair(PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey) {
        this.pub = pGPPublicKey;
        this.priv = pGPPrivateKey;
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPrivateKey getPrivateKey() {
        return this.priv;
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }
}

