/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.Request;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.Req;

public class OCSPReq
implements X509Extension {
    private OCSPRequest req;
    private X509Certificate[] chain = null;

    public OCSPReq(InputStream inputStream) throws IOException {
        this.req = OCSPRequest.getInstance(new ASN1InputStream(inputStream).readObject());
    }

    public OCSPReq(OCSPRequest oCSPRequest) {
        this.req = oCSPRequest;
    }

    public OCSPReq(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    private ArrayList getCertList(String string) throws OCSPException, NoSuchProviderException {
        CertificateFactory certificateFactory;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", string);
        }
        catch (CertificateException certificateException) {
            throw new OCSPException("can't get certificate factory.", certificateException);
        }
        ASN1Sequence aSN1Sequence = this.req.getOptionalSignature().getCerts();
        if (aSN1Sequence != null) {
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    aSN1OutputStream.writeObject(enumeration.nextElement());
                    arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
                }
                catch (IOException iOException) {
                    throw new OCSPException("can't re-encode certificate!", iOException);
                }
                catch (CertificateException certificateException) {
                    throw new OCSPException("can't re-encode certificate!", certificateException);
                }
                byteArrayOutputStream.reset();
            }
        }
        return arrayList;
    }

    public CertStore getCertificates(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, OCSPException {
        if (!this.isSigned()) {
            return null;
        }
        try {
            return CertStore.getInstance(string, (CertStoreParameters)new CollectionCertStoreParameters(this.getCertList(string2)), string2);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException("can't setup the CertStore", invalidAlgorithmParameterException);
        }
    }

    public X509Certificate[] getCerts(String string) throws OCSPException, NoSuchProviderException {
        if (!this.isSigned()) {
            return null;
        }
        ArrayList arrayList = this.getCertList(string);
        return arrayList.toArray(new X509Certificate[arrayList.size()]);
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this.req);
        return byteArrayOutputStream.toByteArray();
    }

    private Set getExtensionOIDs(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        X509Extensions x509Extensions = this.getRequestExtensions();
        if (x509Extensions != null) {
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                org.bouncycastle.asn1.x509.X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        org.bouncycastle.asn1.x509.X509Extension x509Extension;
        X509Extensions x509Extensions = this.getRequestExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            try {
                dEROutputStream.writeObject(x509Extension.getValue());
                return byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public X509Extensions getRequestExtensions() {
        return X509Extensions.getInstance(this.req.getTbsRequest().getRequestExtensions());
    }

    public Req[] getRequestList() {
        ASN1Sequence aSN1Sequence = this.req.getTbsRequest().getRequestList();
        Req[] reqArray = new Req[aSN1Sequence.size()];
        int n = 0;
        while (n != reqArray.length) {
            reqArray[n] = new Req(Request.getInstance(aSN1Sequence.getObjectAt(n)));
            ++n;
        }
        return reqArray;
    }

    public GeneralName getRequestorName() {
        return GeneralName.getInstance(this.req.getTbsRequest().getRequestorName());
    }

    public byte[] getSignature() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignature().getBytes();
    }

    public String getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.req.getOptionalSignature().getSignatureAlgorithm().getObjectId().getId();
    }

    public int getVersion() {
        return this.req.getTbsRequest().getVersion().getValue().intValue() + 1;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    public boolean isSigned() {
        return this.req.getOptionalSignature() != null;
    }

    public boolean verify(PublicKey publicKey, String string) throws OCSPException, NoSuchProviderException {
        if (!this.isSigned()) {
            throw new OCSPException("attempt to verify signature on unsigned object");
        }
        try {
            Signature signature = Signature.getInstance(this.getSignatureAlgOID(), string);
            signature.initVerify(publicKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.req.getTbsRequest());
            signature.update(byteArrayOutputStream.toByteArray());
            return signature.verify(this.getSignature());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing sig: " + exception, exception);
        }
    }
}

