/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.mail.smime.SMIMEException;

public class SMIMEGenerator {
    protected boolean useBase64 = true;
    protected String encoding = "";

    protected SMIMEGenerator() {
    }

    public void setContentTransferEncoding(String string) {
        this.encoding = string;
        this.useBase64 = string.toLowerCase().equals("base64");
    }

    protected MimeBodyPart makeContentBodyPart(MimeBodyPart mimeBodyPart) throws SMIMEException {
        try {
            Header header;
            MimeMessage mimeMessage = new MimeMessage((Session)null);
            Enumeration enumeration = mimeBodyPart.getAllHeaders();
            mimeMessage.setDataHandler(mimeBodyPart.getDataHandler());
            while (enumeration.hasMoreElements()) {
                header = (Header)enumeration.nextElement();
                mimeMessage.setHeader(header.getName(), header.getValue());
            }
            mimeMessage.saveChanges();
            enumeration = mimeMessage.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                header = (Header)enumeration.nextElement();
                if (!header.getName().toLowerCase().startsWith("content-")) continue;
                mimeBodyPart.setHeader(header.getName(), header.getValue());
            }
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception saving message state.", (Exception)((Object)messagingException));
        }
        return mimeBodyPart;
    }

    protected MimeBodyPart makeContentBodyPart(MimeMessage mimeMessage) throws SMIMEException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        try {
            mimeMessage.removeHeader("Message-Id");
            mimeMessage.removeHeader("Mime-Version");
            mimeBodyPart.setContent(mimeMessage.getContent(), mimeMessage.getContentType());
            Enumeration enumeration = mimeMessage.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                mimeBodyPart.setHeader(header.getName(), header.getValue());
            }
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception saving message state.", (Exception)((Object)messagingException));
        }
        catch (IOException iOException) {
            throw new SMIMEException("exception getting message content.", iOException);
        }
        return mimeBodyPart;
    }
}

