/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHKey;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.ElGamalEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.interfaces.ElGamalKey;
import org.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.bouncycastle.jce.provider.ElGamalUtil;
import org.bouncycastle.jce.provider.WrapCipherSpi;

public class JCEElGamalCipher
extends WrapCipherSpi {
    private BufferedAsymmetricBlockCipher cipher;
    private boolean publicKeyOnly = false;
    private boolean privateKeyOnly = false;

    public JCEElGamalCipher(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.cipher = new BufferedAsymmetricBlockCipher(asymmetricBlockCipher);
    }

    public JCEElGamalCipher(boolean bl, boolean bl2, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.publicKeyOnly = bl;
        this.privateKeyOnly = bl2;
        this.cipher = new BufferedAsymmetricBlockCipher(asymmetricBlockCipher);
    }

    protected int engineGetBlockSize() {
        return this.cipher.getInputBlockSize();
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof ElGamalKey) {
            ElGamalKey elGamalKey = (ElGamalKey)((Object)key);
            return elGamalKey.getParameters().getP().bitLength();
        }
        if (key instanceof DHKey) {
            DHKey dHKey = (DHKey)((Object)key);
            return dHKey.getParams().getP().bitLength();
        }
        throw new IllegalArgumentException("not an ElGamal key!");
    }

    protected int engineGetOutputSize(int n) {
        return this.cipher.getOutputBlockSize();
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineSetMode(String string) {
        throw new IllegalArgumentException("can't support mode " + string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException(string + " unavailable with ElGamal.");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        if (algorithmParameterSpec != null) throw new IllegalArgumentException("unknown parameter type.");
        if (key instanceof ElGamalPublicKey) {
            AsymmetricKeyParameter asymmetricKeyParameter = ElGamalUtil.generatePublicKeyParameter((PublicKey)key);
        } else {
            if (!(key instanceof ElGamalPrivateKey)) throw new InvalidKeyException("unknown key type passed to ElGamal");
            AsymmetricKeyParameter asymmetricKeyParameter = ElGamalUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        if (secureRandom != null) {
            void var5_7;
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)var5_7, secureRandom);
        }
        switch (n) {
            case 1: 
            case 3: {
                void var5_9;
                this.cipher.init(true, (CipherParameters)var5_9);
                return;
            }
            case 2: 
            case 4: {
                void var5_9;
                this.cipher.init(false, (CipherParameters)var5_9);
                return;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("can't handle parameters in ElGamal");
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.cipher.processBytes(byArray, n, n2);
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.cipher.processBytes(byArray, n, n2);
        return 0;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        this.cipher.processBytes(byArray, n, n2);
        try {
            return this.cipher.doFinal();
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3;
        this.cipher.processBytes(byArray, n, n2);
        try {
            byArray3 = this.cipher.doFinal();
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
        for (int i = 0; i != byArray3.length; ++i) {
            byArray2[n3 + i] = byArray3[i];
        }
        return byArray3.length;
    }

    public static class PKCS1v1_5Padding
    extends JCEElGamalCipher {
        public PKCS1v1_5Padding() {
            super(new PKCS1Encoding(new ElGamalEngine()));
        }
    }

    public static class NoPadding
    extends JCEElGamalCipher {
        public NoPadding() {
            super(new ElGamalEngine());
        }
    }
}

