/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class FIPSDESTest
implements Test {
    static String[] fips1Tests = new String[]{"DES/ECB/NoPadding", "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53", "DES/CBC/NoPadding", "e5c7cdde872bf27c43e934008c389c0f683788499a7c05f6", "DES/CFB/NoPadding", "f3096249c7f46e51a69e839b1a92f78403467133898ea622"};
    static String[] fips2Tests = new String[]{"DES/CFB8/NoPadding", "f31fda07011462ee187f", "DES/OFB8/NoPadding", "f34a2850c9c64985d684"};
    static byte[] input1 = Hex.decode((String)"4e6f77206973207468652074696d6520666f7220616c6c20");
    static byte[] input2 = Hex.decode((String)"4e6f7720697320746865");

    public String getName() {
        return "FIPSDESTest";
    }

    private boolean equalArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult test(String string, byte[] byArray, byte[] byArray2) {
        Cipher cipher;
        Cipher cipher2;
        SecretKeySpec secretKeySpec;
        IvParameterSpec ivParameterSpec = new IvParameterSpec(Hex.decode((String)"1234567890abcdef"));
        try {
            secretKeySpec = new SecretKeySpec(Hex.decode((String)"0123456789abcdef"), "DES");
            cipher2 = Cipher.getInstance(string, "BC");
            cipher = Cipher.getInstance(string, "BC");
            if (string.startsWith("DES/ECB")) {
                cipher.init(1, secretKeySpec);
            } else {
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed initialisation - " + exception.toString(), exception);
        }
        try {
            if (string.startsWith("DES/ECB")) {
                cipher2.init(2, secretKeySpec);
            } else {
                cipher2.init(2, (Key)secretKeySpec, ivParameterSpec);
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed initialisation - " + exception.toString(), exception);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            for (int i = 0; i != byArray.length / 2; ++i) {
                cipherOutputStream.write(byArray[i]);
            }
            cipherOutputStream.write(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - " + iOException.toString());
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (!this.equalArray(byArray3, byArray2)) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher2);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray3 = new byte[byArray.length];
            for (int i = 0; i != byArray.length / 2; ++i) {
                byArray3[i] = (byte)dataInputStream.read();
            }
            dataInputStream.readFully(byArray3, byArray.length / 2, byArray3.length - byArray.length / 2);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed encryption - " + exception.toString());
        }
        if (!this.equalArray(byArray3, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": " + string + " failed decryption - expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray3)));
        }
        return new SimpleTestResult(true, this.getName() + ": " + string + " Okay");
    }

    public TestResult perform() {
        TestResult testResult;
        int n;
        for (n = 0; n != fips1Tests.length; n += 2) {
            testResult = this.test(fips1Tests[n], input1, Hex.decode((String)fips1Tests[n + 1]));
            if (testResult.isSuccessful()) continue;
            return testResult;
        }
        for (n = 0; n != fips2Tests.length; n += 2) {
            testResult = this.test(fips2Tests[n], input2, Hex.decode((String)fips2Tests[n + 1]));
            if (testResult.isSuccessful()) continue;
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) throws KeyException, InvalidAlgorithmParameterException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        FIPSDESTest fIPSDESTest = new FIPSDESTest();
        TestResult testResult = fIPSDESTest.perform();
        System.out.println(testResult.toString());
    }
}

