/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Set;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.PKIXParameters;

public class PKIXBuilderParameters
extends PKIXParameters {
    private int maxPathLength = 5;

    public PKIXBuilderParameters(Set set, CertSelector certSelector) throws InvalidAlgorithmParameterException {
        super(set);
        this.setTargetCertConstraints(certSelector);
    }

    public PKIXBuilderParameters(KeyStore keyStore, CertSelector certSelector) throws KeyStoreException, InvalidAlgorithmParameterException {
        super(keyStore);
        this.setTargetCertConstraints(certSelector);
    }

    public void setMaxPathLength(int n) {
        if (n < -1) {
            throw new InvalidParameterException("the maximum path length parameter can not be less than -1");
        }
        this.maxPathLength = n;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKIXBuilderParameters [\n");
        stringBuffer.append(super.toString());
        stringBuffer.append("  Maximum Path Length: ");
        stringBuffer.append(this.getMaxPathLength());
        stringBuffer.append("\n]\n");
        return stringBuffer.toString();
    }
}

