/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(String string) {
        this.idData = new byte[string.length()];
        int n = 0;
        while (n != string.length()) {
            this.idData[n] = (byte)string.charAt(n);
            ++n;
        }
    }

    public UserIDPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.idData = new byte[bCPGInputStream.available()];
        bCPGInputStream.readFully(this.idData);
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(13, this.idData, true);
    }

    public String getID() {
        char[] cArray = new char[this.idData.length];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(this.idData[n] & 0xFF);
            ++n;
        }
        return new String(cArray);
    }
}

