/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.IEKeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class ECIESTest
implements Test {
    ECIESTest() {
    }

    public String getName() {
        return "ECIES";
    }

    private boolean sameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult perform() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
            ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
            ECParameterSpec eCParameterSpec = new ECParameterSpec((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
            keyPairGenerator.initialize((AlgorithmParameterSpec)eCParameterSpec, new SecureRandom());
            TestResult testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
            keyPairGenerator.initialize(192, new SecureRandom());
            testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
            keyPairGenerator.initialize(239, new SecureRandom());
            testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            keyPairGenerator = KeyPairGenerator.getInstance("ECIES", "BC");
            keyPairGenerator.initialize(256, new SecureRandom());
            testResult = this.performTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            testResult = this.performDefTest(keyPairGenerator);
            if (!testResult.isSuccessful()) {
                return testResult;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult performTest(KeyPairGenerator keyPairGenerator) {
        try {
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
            PublicKey publicKey2 = keyPair2.getPublic();
            PrivateKey privateKey2 = keyPair2.getPrivate();
            Cipher cipher = Cipher.getInstance("ECIES", "BC");
            Cipher cipher2 = Cipher.getInstance("ECIES", "BC");
            IEKeySpec iEKeySpec = new IEKeySpec(privateKey, publicKey2);
            IEKeySpec iEKeySpec2 = new IEKeySpec(privateKey2, publicKey);
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
            byte[] byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
            IESParameterSpec iESParameterSpec = new IESParameterSpec(byArray, byArray2, 128);
            cipher.init(1, (Key)iEKeySpec, (AlgorithmParameterSpec)iESParameterSpec);
            cipher2.init(2, (Key)iEKeySpec2, (AlgorithmParameterSpec)iESParameterSpec);
            byte[] byArray3 = Hex.decode((String)"1234567890abcdef");
            byte[] byArray4 = cipher.doFinal(byArray3, 0, byArray3.length);
            byte[] byArray5 = cipher2.doFinal(byArray4, 0, byArray4.length);
            if (!this.sameAs(byArray5, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": stream cipher test failed");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult performDefTest(KeyPairGenerator keyPairGenerator) {
        try {
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            KeyPair keyPair2 = keyPairGenerator.generateKeyPair();
            PublicKey publicKey2 = keyPair2.getPublic();
            PrivateKey privateKey2 = keyPair2.getPrivate();
            Cipher cipher = Cipher.getInstance("ECIES", "BC");
            Cipher cipher2 = Cipher.getInstance("ECIES", "BC");
            IEKeySpec iEKeySpec = new IEKeySpec(privateKey, publicKey2);
            IEKeySpec iEKeySpec2 = new IEKeySpec(privateKey2, publicKey);
            cipher.init(1, (Key)iEKeySpec);
            AlgorithmParameters algorithmParameters = cipher.getParameters();
            cipher2.init(2, (Key)iEKeySpec2, algorithmParameters);
            byte[] byArray = Hex.decode((String)"1234567890abcdef");
            byte[] byArray2 = cipher.doFinal(byArray, 0, byArray.length);
            byte[] byArray3 = cipher2.doFinal(byArray2, 0, byArray2.length);
            if (!this.sameAs(byArray3, byArray)) {
                return new SimpleTestResult(false, this.getName() + ": stream cipher test failed");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": stream cipher test exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ECIESTest eCIESTest = new ECIESTest();
        TestResult testResult = eCIESTest.perform();
        System.out.println(testResult);
    }
}

