/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PBETest
implements Test {
    private PKCS12Test[] pkcs12Tests = new PKCS12Test[]{new PKCS12Test("DESede", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC", (Digest)new SHA1Digest(), 192, 64), new PKCS12Test("DESede", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC", (Digest)new SHA1Digest(), 128, 64), new PKCS12Test("RC4", "PBEWITHSHAAND128BITRC4", (Digest)new SHA1Digest(), 128, 0), new PKCS12Test("RC4", "PBEWITHSHAAND40BITRC4", (Digest)new SHA1Digest(), 40, 0), new PKCS12Test("RC2", "PBEWITHSHAAND128BITRC2-CBC", (Digest)new SHA1Digest(), 128, 64), new PKCS12Test("RC2", "PBEWITHSHAAND40BITRC2-CBC", (Digest)new SHA1Digest(), 40, 64), new PKCS12Test("AES", "PBEWithSHA1And128BitAES-CBC-BC", (Digest)new SHA1Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA1And192BitAES-CBC-BC", (Digest)new SHA1Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA1And256BitAES-CBC-BC", (Digest)new SHA1Digest(), 256, 128), new PKCS12Test("AES", "PBEWithSHA256And128BitAES-CBC-BC", (Digest)new SHA256Digest(), 128, 128), new PKCS12Test("AES", "PBEWithSHA256And192BitAES-CBC-BC", (Digest)new SHA256Digest(), 192, 128), new PKCS12Test("AES", "PBEWithSHA256And256BitAES-CBC-BC", (Digest)new SHA256Digest(), 256, 128)};
    private OpenSSLTest[] openSSLTests = new OpenSSLTest[]{new OpenSSLTest("AES", "PBEWITHMD5AND128BITAES-CBC-OPENSSL", 128, 128), new OpenSSLTest("AES", "PBEWITHMD5AND192BITAES-CBC-OPENSSL", 192, 128), new OpenSSLTest("AES", "PBEWITHMD5AND256BITAES-CBC-OPENSSL", 256, 128)};
    static byte[] message = Hex.decode((String)"4869205468657265");
    private byte[] hMac1 = Hex.decode((String)"bcc42174ccb04f425d9a5c8c4a95d6fd7c372911");
    private byte[] hMac2 = Hex.decode((String)"cb1d8bdb6aca9e3fa8980d6eb41ab28a7eb2cfd6");

    private Cipher makePBECipherUsingParam(String string, int n, char[] cArray, byte[] byArray, int n2) throws Exception {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        Cipher cipher = Cipher.getInstance(string, "BC");
        cipher.init(n, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
        return cipher;
    }

    private Cipher makePBECipherWithoutParam(String string, int n, char[] cArray, byte[] byArray, int n2) throws Exception {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n2);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
        Cipher cipher = Cipher.getInstance(string, "BC");
        cipher.init(n, secretKeyFactory.generateSecret(pBEKeySpec));
        return cipher;
    }

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult testPBEHMac(String string, byte[] byArray) {
        Mac mac;
        SecretKey secretKey;
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            secretKey = secretKeyFactory.generateSecret(new PBEKeySpec("hello".toCharArray()));
            mac = Mac.getInstance(string, "BC");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
        try {
            mac.init(secretKey, new PBEParameterSpec(new byte[20], 100));
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
        mac.reset();
        mac.update(message, 0, message.length);
        byte[] byArray2 = mac.doFinal();
        if (!this.arrayEquals(byArray2, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        byte[] byArray = Hex.decode((String)"1234567890abcdefabcdef1234567890fedbca098765");
        try {
            TestResult testResult;
            int n;
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS7Padding", "BC");
            cipher.init(1, (Key)new SecretKeySpec(Hex.decode((String)"30e69252758e5346"), "DES"), new IvParameterSpec(Hex.decode((String)"7c1c1ab9c454a688")));
            byte[] byArray2 = cipher.doFinal(byArray);
            char[] cArray = new char[]{'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
            Cipher cipher2 = this.makePBECipherUsingParam("PBEWithSHA1AndDES", 2, cArray, Hex.decode((String)"7d60435f02e9e0ae"), 2048);
            byte[] byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": DES failed");
            }
            cipher2 = this.makePBECipherWithoutParam("PBEWithSHA1AndDES", 2, cArray, Hex.decode((String)"7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": DES failed without param");
            }
            cipher = Cipher.getInstance("DESede/CBC/PKCS7Padding", "BC");
            cipher.init(1, (Key)new SecretKeySpec(Hex.decode((String)"732f2d33c801732b7206756cbd44f9c1c103ddd97c7cbe8e"), "DES"), new IvParameterSpec(Hex.decode((String)"b07bf522c8d608b8")));
            byArray2 = cipher.doFinal(byArray);
            cipher2 = this.makePBECipherUsingParam("PBEWithSHAAnd3-KeyTripleDES-CBC", 2, cArray, Hex.decode((String)"7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": DESede failed");
            }
            cipher = Cipher.getInstance("RC2/CBC/PKCS7Padding", "BC");
            cipher.init(1, (Key)new SecretKeySpec(Hex.decode((String)"732f2d33c8"), "RC2"), new IvParameterSpec(Hex.decode((String)"b07bf522c8d608b8")));
            byArray2 = cipher.doFinal(byArray);
            cipher2 = this.makePBECipherUsingParam("PBEWithSHAAnd40BitRC2-CBC", 2, cArray, Hex.decode((String)"7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": RC2 failed");
            }
            cipher = Cipher.getInstance("RC4", "BC");
            cipher.init(1, new SecretKeySpec(Hex.decode((String)"732f2d33c801732b7206756cbd44f9c1"), "RC4"));
            byArray2 = cipher.doFinal(byArray);
            cipher2 = this.makePBECipherUsingParam("PBEWithSHAAnd128BitRC4", 2, cArray, Hex.decode((String)"7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": RC4 failed");
            }
            cipher2 = this.makePBECipherWithoutParam("PBEWithSHAAnd128BitRC4", 2, cArray, Hex.decode((String)"7d60435f02e9e0ae"), 2048);
            byArray3 = cipher2.doFinal(byArray2);
            if (!this.arrayEquals(byArray, byArray3)) {
                return new SimpleTestResult(false, this.getName() + ": RC4 failed without param");
            }
            for (n = 0; n != this.pkcs12Tests.length; ++n) {
                testResult = this.pkcs12Tests[n].perform();
                if (testResult.isSuccessful()) continue;
                return testResult;
            }
            for (n = 0; n != this.openSSLTests.length; ++n) {
                testResult = this.openSSLTests[n].perform();
                if (testResult.isSuccessful()) continue;
                return testResult;
            }
            TestResult testResult2 = this.testPBEHMac("PBEWithHMacSHA1", this.hMac1);
            if (!testResult2.isSuccessful()) {
                return testResult2;
            }
            testResult2 = this.testPBEHMac("PBEWithHMacRIPEMD160", this.hMac2);
            if (!testResult2.isSuccessful()) {
                return testResult2;
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "PBETest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PBETest pBETest = new PBETest();
        TestResult testResult = pBETest.perform();
        if (((SimpleTestResult)testResult).getException() != null) {
            ((SimpleTestResult)testResult).getException().printStackTrace();
        }
        System.out.println(testResult.toString());
    }

    private class PKCS12Test
    implements Test {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        Digest digest;
        int keySize;
        int ivSize;

        PKCS12Test(String string, String string2, Digest digest, int n, int n2) {
            this.password = string2.toCharArray();
            this.baseAlgorithm = string;
            this.algorithm = string2;
            this.digest = digest;
            this.keySize = n;
            this.ivSize = n2;
        }

        public String getName() {
            return "PKCS12PBE";
        }

        public TestResult perform() {
            byte[] byArray = new byte[this.digest.getDigestSize()];
            int n = 100;
            this.digest.doFinal(byArray, 0);
            try {
                Cipher cipher;
                PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(this.digest);
                pKCS12ParametersGenerator.init(PBEParametersGenerator.PKCS12PasswordToBytes((char[])this.password), byArray, n);
                ParametersWithIV parametersWithIV = (ParametersWithIV)pKCS12ParametersGenerator.generateDerivedParameters(this.keySize, this.ivSize);
                SecretKeySpec secretKeySpec = new SecretKeySpec(((KeyParameter)parametersWithIV.getParameters()).getKey(), this.baseAlgorithm);
                if (this.baseAlgorithm.equals("RC4")) {
                    cipher = Cipher.getInstance(this.baseAlgorithm, "BC");
                    cipher.init(1, secretKeySpec);
                } else {
                    cipher = Cipher.getInstance(this.baseAlgorithm + "/CBC/PKCS7Padding", "BC");
                    cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(parametersWithIV.getIV()));
                }
                byte[] byArray2 = cipher.doFinal(byArray);
                cipher = Cipher.getInstance(this.algorithm, "BC");
                PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password, byArray, n);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm, "BC");
                cipher.init(2, secretKeyFactory.generateSecret(pBEKeySpec));
                byte[] byArray3 = cipher.doFinal(byArray2);
                if (!PBETest.this.arrayEquals(byArray, byArray3)) {
                    return new SimpleTestResult(false, this.getName() + ": " + this.algorithm + "failed encryption/decryption test");
                }
                AlgorithmParameters algorithmParameters = cipher.getParameters();
                PBEParameterSpec pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
                if (!PBETest.this.arrayEquals(byArray, pBEParameterSpec.getSalt())) {
                    return new SimpleTestResult(false, this.getName() + ": " + this.algorithm + "failed salt test");
                }
                if (n != pBEParameterSpec.getIterationCount()) {
                    return new SimpleTestResult(false, this.getName() + ": " + this.algorithm + "failed count test");
                }
                pBEKeySpec = new PBEKeySpec(this.password);
                cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), algorithmParameters);
                byArray3 = cipher.doFinal(byArray2);
                if (!PBETest.this.arrayEquals(byArray, byArray3)) {
                    return new SimpleTestResult(false, this.getName() + ": " + this.algorithm + "failed encryption/decryption test");
                }
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": " + this.algorithm + " failed - exception " + exception, exception);
            }
        }
    }

    private class OpenSSLTest
    implements Test {
        char[] password;
        String baseAlgorithm;
        String algorithm;
        int keySize;
        int ivSize;

        OpenSSLTest(String string, String string2, int n, int n2) {
            this.password = string2.toCharArray();
            this.baseAlgorithm = string;
            this.algorithm = string2;
            this.keySize = n;
            this.ivSize = n2;
        }

        public String getName() {
            return "OpenSSLPBE";
        }

        public TestResult perform() {
            byte[] byArray = new byte[16];
            int n = 100;
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = (byte)i;
            }
            try {
                Cipher cipher;
                OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
                openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])this.password), byArray, n);
                ParametersWithIV parametersWithIV = (ParametersWithIV)openSSLPBEParametersGenerator.generateDerivedParameters(this.keySize, this.ivSize);
                SecretKeySpec secretKeySpec = new SecretKeySpec(((KeyParameter)parametersWithIV.getParameters()).getKey(), this.baseAlgorithm);
                if (this.baseAlgorithm.equals("RC4")) {
                    cipher = Cipher.getInstance(this.baseAlgorithm, "BC");
                    cipher.init(1, secretKeySpec);
                } else {
                    cipher = Cipher.getInstance(this.baseAlgorithm + "/CBC/PKCS7Padding", "BC");
                    cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(parametersWithIV.getIV()));
                }
                byte[] byArray2 = cipher.doFinal(byArray);
                cipher = Cipher.getInstance(this.algorithm, "BC");
                PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password, byArray, n);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm, "BC");
                cipher.init(2, secretKeyFactory.generateSecret(pBEKeySpec));
                byte[] byArray3 = cipher.doFinal(byArray2);
                if (!PBETest.this.arrayEquals(byArray, byArray3)) {
                    return new SimpleTestResult(false, this.getName() + ": " + this.algorithm + "failed encryption/decryption test");
                }
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": " + this.algorithm + " failed - exception " + exception, exception);
            }
        }
    }
}

