/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GOFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GOST28147Test
extends CipherTest {
    static String input1 = "0000000000000000";
    static String output1 = "1b0bbc32cebcab42";
    static String input2 = "bc350e71aac5f5c2";
    static String output2 = "d35ab653493b49f5";
    static String input3 = "bc350e71aa11345709acde";
    static String output3 = "8824c124c4fd14301fb1e8";
    static String input4 = "000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f";
    static String output4 = "29b7083e0a6d955ca0ec5b04fdb4ea41949f1dd2efdf17baffc1780b031f3934";
    static byte[] TestSBox;
    static Test[] tests;
    private static final int GOST28147_KEY_LENGTH = 32;

    static {
        byte[] byArray = new byte[128];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 15;
        byArray[17] = 14;
        byArray[18] = 13;
        byArray[19] = 12;
        byArray[20] = 11;
        byArray[21] = 10;
        byArray[22] = 9;
        byArray[23] = 8;
        byArray[24] = 7;
        byArray[25] = 6;
        byArray[26] = 5;
        byArray[27] = 4;
        byArray[28] = 3;
        byArray[29] = 2;
        byArray[30] = 1;
        byArray[33] = 1;
        byArray[34] = 2;
        byArray[35] = 3;
        byArray[36] = 4;
        byArray[37] = 5;
        byArray[38] = 6;
        byArray[39] = 7;
        byArray[40] = 8;
        byArray[41] = 9;
        byArray[42] = 10;
        byArray[43] = 11;
        byArray[44] = 12;
        byArray[45] = 13;
        byArray[46] = 14;
        byArray[47] = 15;
        byArray[48] = 15;
        byArray[49] = 14;
        byArray[50] = 13;
        byArray[51] = 12;
        byArray[52] = 11;
        byArray[53] = 10;
        byArray[54] = 9;
        byArray[55] = 8;
        byArray[56] = 7;
        byArray[57] = 6;
        byArray[58] = 5;
        byArray[59] = 4;
        byArray[60] = 3;
        byArray[61] = 2;
        byArray[62] = 1;
        byArray[65] = 1;
        byArray[66] = 2;
        byArray[67] = 3;
        byArray[68] = 4;
        byArray[69] = 5;
        byArray[70] = 6;
        byArray[71] = 7;
        byArray[72] = 8;
        byArray[73] = 9;
        byArray[74] = 10;
        byArray[75] = 11;
        byArray[76] = 12;
        byArray[77] = 13;
        byArray[78] = 14;
        byArray[79] = 15;
        byArray[80] = 15;
        byArray[81] = 14;
        byArray[82] = 13;
        byArray[83] = 12;
        byArray[84] = 11;
        byArray[85] = 10;
        byArray[86] = 9;
        byArray[87] = 8;
        byArray[88] = 7;
        byArray[89] = 6;
        byArray[90] = 5;
        byArray[91] = 4;
        byArray[92] = 3;
        byArray[93] = 2;
        byArray[94] = 1;
        byArray[97] = 1;
        byArray[98] = 2;
        byArray[99] = 3;
        byArray[100] = 4;
        byArray[101] = 5;
        byArray[102] = 6;
        byArray[103] = 7;
        byArray[104] = 8;
        byArray[105] = 9;
        byArray[106] = 10;
        byArray[107] = 11;
        byArray[108] = 12;
        byArray[109] = 13;
        byArray[110] = 14;
        byArray[111] = 15;
        byArray[112] = 15;
        byArray[113] = 14;
        byArray[114] = 13;
        byArray[115] = 12;
        byArray[116] = 11;
        byArray[117] = 10;
        byArray[118] = 9;
        byArray[119] = 8;
        byArray[120] = 7;
        byArray[121] = 6;
        byArray[122] = 5;
        byArray[123] = 4;
        byArray[124] = 3;
        byArray[125] = 2;
        byArray[126] = 1;
        TestSBox = byArray;
        tests = new Test[]{new BlockCipherVectorTest(1, (BlockCipher)new GOST28147Engine(), (CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(2, (BlockCipher)new CBCBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF")), Hex.decode((String)"1234567890abcdef")), input2, output2), new BlockCipherVectorTest(3, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"0011223344556677889900112233445566778899001122334455667788990011")), Hex.decode((String)"1234567890abcdef")), input3, output3), new BlockCipherVectorTest(4, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5")), Hex.decode((String)"aafd12f659cae634")), input4, output4), new BlockCipherVectorTest(5, (BlockCipher)new GOST28147Engine(), (CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(6, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"D-Test")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "b587f7a0814c911d"), new BlockCipherVectorTest(7, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-Test")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "e8287f53f991d52b"), new BlockCipherVectorTest(8, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "c41009dba22ebe35"), new BlockCipherVectorTest(9, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-B")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "80d8723fcd3aba28"), new BlockCipherVectorTest(10, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-C")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "739f6f95068499b5"), new BlockCipherVectorTest(11, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"E-D")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "4663f720f4340f57"), new BlockCipherVectorTest(12, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox((String)"D-A")), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "5bb0a31d218ed564"), new BlockCipherVectorTest(13, (BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 8), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"546d203368656c326973652073736e62206167796967747473656865202c3d73")), TestSBox), Hex.decode((String)"1234567890abcdef")), "0000000000000000", "c3af96ef788667c5"), new BlockCipherVectorTest(14, (BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()), (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(Hex.decode((String)"4ef72b778f0b0bebeef4f077551cb74a927b470ad7d7f2513454569a247e989d")), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef")), "bc350e71aa11345709acde", "1bcc2282707c676fb656dc")};
    }

    GOST28147Test() {
        super(tests);
    }

    private byte[] generateKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        GOST3411Digest gOST3411Digest = new GOST3411Digest();
        gOST3411Digest.update(byArray, 0, byArray.length);
        gOST3411Digest.doFinal(byArray2, 0);
        return byArray2;
    }

    public String getName() {
        return "GOST28147";
    }

    public static void main(String[] stringArray) {
        GOST28147Test gOST28147Test = new GOST28147Test();
        TestResult testResult = gOST28147Test.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        TestResult testResult = super.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray = Hex.decode((String)"4e6f77206973207468652074696d6520666f7220616c6c20");
        byte[] byArray2 = Hex.decode((String)"8ad3c8f56b27ff1fbd46409359bdc796bc350e71aac5f5c0");
        byte[] byArray3 = new byte[byArray.length];
        byte[] byArray4 = this.generateKey(Hex.decode((String)"0123456789abcdef"));
        ParametersWithSBox parametersWithSBox = new ParametersWithSBox((CipherParameters)new KeyParameter(byArray4), GOST28147Engine.getSBox((String)"E-A"));
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new GOST28147Engine());
        bufferedBlockCipher.init(true, (CipherParameters)parametersWithSBox);
        int n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n);
        }
        catch (CryptoException cryptoException) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - exception " + cryptoException.toString(), (Exception)((Object)cryptoException));
        }
        if (byArray3.length != byArray2.length) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
        }
        int n2 = 0;
        while (n2 != byArray3.length) {
            if (byArray3[n2] != byArray2[n2]) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
            }
            ++n2;
        }
        byArray = Hex.decode((String)"bc350e71aac5f5c2");
        byArray2 = Hex.decode((String)"0ebbbafcf38f14a5");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode((String)"0123456789abcdef"));
        parametersWithSBox = new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(byArray4), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef"));
        bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64));
        bufferedBlockCipher.init(true, (CipherParameters)parametersWithSBox);
        n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n);
        }
        catch (CryptoException cryptoException) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - exception " + cryptoException.toString(), (Exception)((Object)cryptoException));
        }
        if (byArray3.length != byArray2.length) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
        }
        int n3 = 0;
        while (n3 != byArray3.length) {
            if (byArray3[n3] != byArray2[n3]) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
            }
            ++n3;
        }
        byArray = Hex.decode((String)"000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        byArray2 = Hex.decode((String)"64988982819f0a1655e226e19ecad79d10cc73bac95c5d7da034786c12294225");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode((String)"aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5"));
        parametersWithSBox = new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(byArray4), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"aafd12f659cae634"));
        bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new GOST28147Engine(), 64));
        bufferedBlockCipher.init(true, (CipherParameters)parametersWithSBox);
        n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n);
        }
        catch (CryptoException cryptoException) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - exception " + cryptoException.toString(), (Exception)((Object)cryptoException));
        }
        if (byArray3.length != byArray2.length) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
        }
        int n4 = 0;
        while (n4 != byArray3.length) {
            if (byArray3[n4] != byArray2[n4]) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
            }
            ++n4;
        }
        byArray = Hex.decode((String)"bc350e71aa11345709acde");
        byArray2 = Hex.decode((String)"1bcc2282707c676fb656dc");
        byArray3 = new byte[byArray.length];
        byArray4 = this.generateKey(Hex.decode((String)"0123456789abcdef"));
        parametersWithSBox = new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(byArray4), GOST28147Engine.getSBox((String)"E-A")), Hex.decode((String)"1234567890abcdef"));
        bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new GOFBBlockCipher((BlockCipher)new GOST28147Engine()));
        bufferedBlockCipher.init(true, (CipherParameters)parametersWithSBox);
        n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
        try {
            bufferedBlockCipher.doFinal(byArray3, n);
        }
        catch (CryptoException cryptoException) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - exception " + cryptoException.toString(), (Exception)((Object)cryptoException));
        }
        if (byArray3.length != byArray2.length) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
        }
        int n5 = 0;
        while (n5 != byArray3.length) {
            if (byArray3[n5] != byArray2[n5]) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed - " + "expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray3)));
            }
            ++n5;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

