/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class ModeTest
implements Test {
    public String getName() {
        return "ModeTest";
    }

    private boolean isEqualTo(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        ModeTest modeTest = new ModeTest();
        TestResult testResult = modeTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        KeyParameter keyParameter = new KeyParameter(Hex.decode((String)"0011223344556677"));
        byte[] byArray = Hex.decode((String)"4e6f7720");
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        OFBBlockCipher oFBBlockCipher = new OFBBlockCipher((BlockCipher)new DESEngine(), 32);
        oFBBlockCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"1122334455667788")));
        oFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        oFBBlockCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"1122334455667788")));
        oFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test 1 - in != out");
        }
        oFBBlockCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"11223344")));
        oFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        oFBBlockCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"0000000011223344")));
        oFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test 2 - in != out");
        }
        CFBBlockCipher cFBBlockCipher = new CFBBlockCipher((BlockCipher)new DESEngine(), 32);
        cFBBlockCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"1122334455667788")));
        cFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        cFBBlockCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"1122334455667788")));
        cFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test 3 - in != out");
        }
        cFBBlockCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"11223344")));
        cFBBlockCipher.processBlock(byArray, 0, byArray2, 0);
        cFBBlockCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, Hex.decode((String)"0000000011223344")));
        cFBBlockCipher.processBlock(byArray2, 0, byArray3, 0);
        if (!this.isEqualTo(byArray3, byArray)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test 4 - in != out");
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

