/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class HMacTest
implements Test {
    static byte[] keyBytes = Hex.decode((String)"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
    static byte[] message = "Hi There".getBytes();
    static byte[] output1 = Hex.decode((String)"b617318655057264e28bc0b6fb378c8ef146be00");
    static byte[] output2 = Hex.decode((String)"5ccec34ea9656392457fa1ac27f08fbc");
    static byte[] output224 = Hex.decode((String)"896fb1128abbdf196832107cd49df33f47b4b1169912ba4f53684b22");
    static byte[] output256 = Hex.decode((String)"b0344c61d8db38535ca8afceaf0bf12b881dc200c9833da726e9376c2e32cff7");
    static byte[] output384 = Hex.decode((String)"afd03944d84895626b0825f4ab46907f15f9dadbe4101ec682aa034c7cebc59cfaea9ea9076ede7f4af152e8b2fa9cb6");
    static byte[] output512 = Hex.decode((String)"87aa7cdea5ef619d4ff0b4241a1d6cb02379f4e2ce4ec2787ad0b30545e17cdedaa833b7d6b8a702038b274eaea3f4e4be9d914eeb61f1702e696c203a126854");
    static byte[] outputOld384 = Hex.decode((String)"0a046aaa0255e432912228f8ccda437c8a8363fb160afb0570ab5b1fd5ddc20eb1888b9ed4e5b6cb5bc034cd9ef70e40");
    static byte[] outputOld512 = Hex.decode((String)"9656975ee5de55e75f2976ecce9a04501060b9dc22a6eda2eaef638966280182477fe09f080b2bf564649cad42af8607a2bd8d02979df3a980f15e2326a0a22a");

    private boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "HMac";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        HMacTest hMacTest = new HMacTest();
        TestResult testResult = hMacTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        TestResult testResult = this.testHMac("HMac-SHA1", output1);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-MD5", output2);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-SHA224", output224);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-SHA256", output256);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-SHA384", output384);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-SHA512", output512);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("OldHMacSHA384", outputOld384);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("OldHMacSHA512", outputOld512);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testExceptions();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    private TestResult testExceptions() {
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1", "BC");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString(), exception);
        }
        byte[] byArray = new byte[]{1, 2, 3, 4, 5};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
        RC5ParameterSpec rC5ParameterSpec = new RC5ParameterSpec(100, 100, 100);
        try {
            mac.init(secretKeySpec, rC5ParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed exception test.", exception);
        }
        try {
            mac.init(null, null);
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed exception test.", exception);
        }
        try {
            mac.init(null);
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed exception test.", exception);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    public TestResult testHMac(String string, byte[] byArray) {
        Mac mac;
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, string);
        try {
            mac = Mac.getInstance(string, "BC");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString(), exception);
        }
        try {
            mac.init(secretKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception " + exception.toString(), exception);
        }
        mac.reset();
        mac.update(message, 0, message.length);
        byte[] byArray2 = mac.doFinal();
        if (!this.arraysEqual(byArray2, byArray)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
        }
        if (string.startsWith("Old")) {
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string, "BC");
            mac.init(keyGenerator.generateKey());
            mac.update(message);
            byArray2 = mac.doFinal();
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed - exception testing key generation " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

