/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.bouncycastle.x509.X509V2CRLGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

class TestUtils {
    TestUtils() {
    }

    public static KeyPair generateRSAKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public static X509Certificate generateRootCert(KeyPair keyPair) throws Exception {
        X509V1CertificateGenerator x509V1CertificateGenerator = new X509V1CertificateGenerator();
        x509V1CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
        x509V1CertificateGenerator.setIssuerDN((X509Name)new X509Principal("CN=Test CA Certificate"));
        x509V1CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V1CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V1CertificateGenerator.setSubjectDN((X509Name)new X509Principal("CN=Test CA Certificate"));
        x509V1CertificateGenerator.setPublicKey(keyPair.getPublic());
        x509V1CertificateGenerator.setSignatureAlgorithm("SHA256WithRSAEncryption");
        return x509V1CertificateGenerator.generateX509Certificate(keyPair.getPrivate(), "BC");
    }

    public static X509Certificate generateIntermediateCert(PublicKey publicKey, PrivateKey privateKey, X509Certificate x509Certificate) throws Exception {
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
        x509V3CertificateGenerator.setIssuerDN((X509Name)PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal("CN=Test Intermediate Certificate"));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm("SHA256WithRSAEncryption");
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(x509Certificate));
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(publicKey));
        x509V3CertificateGenerator.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(0));
        x509V3CertificateGenerator.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(134));
        return x509V3CertificateGenerator.generateX509Certificate(privateKey, "BC");
    }

    public static X509Certificate generateEndEntityCert(PublicKey publicKey, PrivateKey privateKey, X509Certificate x509Certificate) throws Exception {
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
        x509V3CertificateGenerator.setIssuerDN((X509Name)PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal("CN=Test End Certificate"));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm("SHA256WithRSAEncryption");
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(x509Certificate));
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(publicKey));
        x509V3CertificateGenerator.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(false));
        x509V3CertificateGenerator.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(160));
        return x509V3CertificateGenerator.generateX509Certificate(privateKey, "BC");
    }

    public static X509CRL createCRL(X509Certificate x509Certificate, PrivateKey privateKey, BigInteger bigInteger) throws Exception {
        X509V2CRLGenerator x509V2CRLGenerator = new X509V2CRLGenerator();
        Date date = new Date();
        BigInteger bigInteger2 = BigInteger.valueOf(2L);
        x509V2CRLGenerator.setIssuerDN((X509Name)PrincipalUtil.getSubjectX509Principal((X509Certificate)x509Certificate));
        x509V2CRLGenerator.setThisUpdate(date);
        x509V2CRLGenerator.setNextUpdate(new Date(date.getTime() + 100000L));
        x509V2CRLGenerator.setSignatureAlgorithm("SHA256WithRSAEncryption");
        x509V2CRLGenerator.addCRLEntry(bigInteger, date, 9);
        x509V2CRLGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(x509Certificate));
        x509V2CRLGenerator.addExtension(X509Extensions.CRLNumber, false, (DEREncodable)new CRLNumber(BigInteger.valueOf(1L)));
        return x509V2CRLGenerator.generateX509CRL(privateKey, "BC");
    }
}

