/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;

public class SignerInformationStore {
    private HashMap table = new HashMap();

    public SignerInformationStore(Collection collection) {
        for (SignerInformation signerInformation : collection) {
            SignerId signerId = signerInformation.getSID();
            if (this.table.get(signerId) == null) {
                this.table.put(signerId, signerInformation);
                continue;
            }
            Object v = this.table.get(signerId);
            if (v instanceof List) {
                ((List)v).add(signerInformation);
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(signerInformation);
            this.table.put(signerId, arrayList);
        }
    }

    public SignerInformation get(SignerId signerId) {
        Object v = this.table.get(signerId);
        if (v instanceof List) {
            return (SignerInformation)((List)v).get(0);
        }
        return (SignerInformation)v;
    }

    public int size() {
        Iterator iterator = this.table.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof List) {
                n += ((List)v).size();
                continue;
            }
            ++n;
        }
        return n;
    }

    public Collection getSigners() {
        ArrayList arrayList = new ArrayList(this.table.size());
        for (Object v : this.table.values()) {
            if (v instanceof List) {
                arrayList.addAll((List)v);
                continue;
            }
            arrayList.add(v);
        }
        return arrayList;
    }

    public Collection getSigners(SignerId signerId) {
        Object v = this.table.get(signerId);
        if (v instanceof List) {
            return new ArrayList((List)v);
        }
        if (v != null) {
            return Collections.singletonList(v);
        }
        return new ArrayList();
    }
}

