/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GOST3411DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "981e5f3ca30c841487830f84fb433e13ac1101569b9c13584ac483234cd656c0";
    private static String testVec2 = "54686973206973206d6573736167652c206c656e6774683d3332206279746573";
    private static String resVec2 = "2cefc2f7b7bdc514e18ea57fa74ff357e7fa17d652c75f69cb1be7893ede48eb";
    private static String testVec3 = "537570706f736520746865206f726967696e616c206d65737361676520686173206c656e677468203d203530206279746573";
    private static String resVec3 = "c3730c5cbccacf915ac292676f21e8bd4ef75331d9405e5f1a61dc3130a65011";
    private static String testVec4 = "4142434445464748494a4b4c4d4e4f505152535455565758595a6162636465666768696a6b6c6d6e6f707172737475767778797a30313233343536373839";
    private static String resVec4 = "73b70a39497de53a6e08c67b6d4db853540f03e9389299d9b0156ef7e85d0f61";
    private static String testVec5 = "61616161616161616161";
    private static String resVec5 = "8693287aa62f9478f7cb312ec0866b6c4e4a0f11160441e8f4ffcd2715dd554f";

    public String getName() {
        return "GOST3411";
    }

    public TestResult perform() {
        GOST3411Digest gOST3411Digest = new GOST3411Digest();
        byte[] byArray = new byte[gOST3411Digest.getDigestSize()];
        gOST3411Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode((byte[])byArray));
        if (!resVec2.equals(string)) {
            gOST3411Digest.doFinal(byArray, 0);
        }
        if (!resVec1.equals(string = new String(Hex.encode((byte[])byArray)))) {
            return new SimpleTestResult(false, "GOST3411 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byte[] byArray2 = Hex.decode((String)testVec2);
        gOST3411Digest.update(byArray2, 0, byArray2.length);
        gOST3411Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "GOST3411 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec3);
        gOST3411Digest.update(byArray2, 0, byArray2.length);
        gOST3411Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "GOST3411 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        gOST3411Digest.update(byArray2, 0, byArray2.length);
        gOST3411Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "GOST3411 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        gOST3411Digest.update(byArray2, 0, byArray2.length / 2);
        GOST3411Digest gOST3411Digest2 = new GOST3411Digest(gOST3411Digest);
        gOST3411Digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        gOST3411Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "GOST3411 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        gOST3411Digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        gOST3411Digest2.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "GOST3411 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec5);
        int n = 0;
        while (n < 100000) {
            gOST3411Digest.update(byArray2, 0, byArray2.length);
            ++n;
        }
        gOST3411Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec5.equals(string)) {
            return new SimpleTestResult(false, "GOST3411 failing vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec5 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        GOST3411DigestTest gOST3411DigestTest = new GOST3411DigestTest();
        TestResult testResult = gOST3411DigestTest.perform();
        System.out.println(testResult);
    }
}

