/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class AESTest
implements Test {
    static String[] cipherTests = new String[]{"128", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "69c4e0d86a7b0430d8cdb78070b4c55a", "192", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "dda97ca4864cdfe06eaf70a0ec0d7191", "256", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "8ea2b7ca516745bfeafc49904b496089"};

    public String getName() {
        return "AES";
    }

    private boolean equalArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult test(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Cipher cipher;
        Cipher cipher2;
        SecretKeySpec secretKeySpec;
        try {
            secretKeySpec = new SecretKeySpec(byArray, "AES");
            cipher2 = Cipher.getInstance("AES/ECB/NoPadding", "BC");
            cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
            cipher.init(1, secretKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": AES failed initialisation - " + exception.toString(), exception);
        }
        try {
            cipher2.init(2, secretKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": AES failed initialisation - " + exception.toString(), exception);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        try {
            int n2 = 0;
            while (n2 != byArray2.length / 2) {
                cipherOutputStream.write(byArray2[n2]);
                ++n2;
            }
            cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": AES failed encryption - " + iOException.toString(), (Exception)iOException);
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (!this.equalArray(byArray4, byArray3)) {
            return new SimpleTestResult(false, this.getName() + ": AES failed encryption - expected " + new String(Hex.encode((byte[])byArray3)) + " got " + new String(Hex.encode((byte[])byArray4)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher2);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray4 = new byte[byArray2.length];
            int n3 = 0;
            while (n3 != byArray2.length / 2) {
                byArray4[n3] = (byte)dataInputStream.read();
                ++n3;
            }
            dataInputStream.readFully(byArray4, byArray2.length / 2, byArray4.length - byArray2.length / 2);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": AES failed encryption - " + exception.toString(), exception);
        }
        if (!this.equalArray(byArray4, byArray2)) {
            return new SimpleTestResult(false, this.getName() + ": AES failed decryption - expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray4)));
        }
        return new SimpleTestResult(true, this.getName() + ": AES Okay");
    }

    private TestResult wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            Object object;
            Cipher cipher = Cipher.getInstance("AESWrap", "BC");
            cipher.init(3, new SecretKeySpec(byArray, "AES"));
            try {
                object = cipher.wrap(new SecretKeySpec(byArray2, "AES"));
                if (!this.equalArray((byte[])object, byArray3)) {
                    return new SimpleTestResult(false, this.getName() + ": failed wrap test " + n + " expected " + new String(Hex.encode((byte[])byArray3)) + " got " + new String(Hex.encode((byte[])object)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new SimpleTestResult(false, this.getName() + ": failed wrap test exception " + exception.toString(), exception);
            }
            cipher.init(4, new SecretKeySpec(byArray, "AES"));
            try {
                object = cipher.unwrap(byArray3, "AES", 3);
                if (!this.equalArray(object.getEncoded(), byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": failed unwrap test " + n + " expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])object.getEncoded())));
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": failed unwrap test exception " + exception.toString(), exception);
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    private TestResult oidTest() {
        String[] stringArray = new String[]{NISTObjectIdentifiers.id_aes128_ECB.getId(), NISTObjectIdentifiers.id_aes128_CBC.getId(), NISTObjectIdentifiers.id_aes128_OFB.getId(), NISTObjectIdentifiers.id_aes128_CFB.getId(), NISTObjectIdentifiers.id_aes192_ECB.getId(), NISTObjectIdentifiers.id_aes192_CBC.getId(), NISTObjectIdentifiers.id_aes192_OFB.getId(), NISTObjectIdentifiers.id_aes192_CFB.getId(), NISTObjectIdentifiers.id_aes256_ECB.getId(), NISTObjectIdentifiers.id_aes256_CBC.getId(), NISTObjectIdentifiers.id_aes256_OFB.getId(), NISTObjectIdentifiers.id_aes256_CFB.getId()};
        String[] stringArray2 = new String[]{"AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding"};
        try {
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
            IvParameterSpec ivParameterSpec = new IvParameterSpec(new byte[16]);
            int n = 0;
            while (n != stringArray.length) {
                Cipher cipher = Cipher.getInstance(stringArray[n], "BC");
                Cipher cipher2 = Cipher.getInstance(stringArray2[n], "BC");
                KeyGenerator keyGenerator = KeyGenerator.getInstance(stringArray[n], "BC");
                SecretKey secretKey = keyGenerator.generateKey();
                if (stringArray2[n].startsWith("AES/ECB")) {
                    cipher.init(1, secretKey);
                    cipher2.init(2, secretKey);
                } else {
                    cipher.init(1, (Key)secretKey, ivParameterSpec);
                    cipher2.init(2, (Key)secretKey, ivParameterSpec);
                }
                byte[] byArray2 = cipher2.doFinal(cipher.doFinal(byArray));
                if (!this.equalArray(byArray, byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": failed OID test");
                }
                if (secretKey.getEncoded().length != 16 + n / 4 * 8) {
                    return new SimpleTestResult(false, this.getName() + ": failed key length test");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        byte[] byArray;
        byte[] byArray2;
        TestResult testResult;
        int n = 0;
        while (n != cipherTests.length) {
            testResult = this.test(Integer.parseInt(cipherTests[n]), Hex.decode((String)cipherTests[n + 1]), Hex.decode((String)cipherTests[n + 2]), Hex.decode((String)cipherTests[n + 3]));
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            n += 4;
        }
        byte[] byArray3 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");
        testResult = this.wrapTest(1, byArray3, byArray2 = Hex.decode((String)"00112233445566778899aabbccddeeff"), byArray = Hex.decode((String)"1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.oidTest();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        AESTest aESTest = new AESTest();
        TestResult testResult = aESTest.perform();
        System.out.println(testResult.toString());
    }
}

