/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.jce.interfaces.GOST3410PublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GOST3410Test
implements Test {
    SecureRandom random = new SecureRandom(){
        boolean firstLong = true;

        public long nextLong() {
            String string = "0x13DA8B9D";
            String string2 = "0xA0E9DE4B";
            if (this.firstLong) {
                this.firstLong = false;
                return Long.decode(string);
            }
            return Long.decode(string2);
        }

        public void nextBytes(byte[] byArray) {
            byte[] byArray2 = Hex.decode((String)"41ab97857f42614355d32db0b1069f109a4da283676c7c53a68185b4");
            System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        }
    };
    Test[] tests = new Test[]{new ECGOST3410Test(), new GenerationTest(), new ParametersTest()};

    private BigInteger[] decode(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        int n = 0;
        while (n != 32) {
            byArray3[n] = byArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 != 32) {
            byArray2[n2] = byArray[32 + n2];
            ++n2;
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{new BigInteger(1, byArray2), new BigInteger(1, byArray3)};
        return bigIntegerArray;
    }

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "GOST3410/ECGOST3410";
    }

    public TestResult perform() {
        int n = 0;
        while (n != this.tests.length) {
            TestResult testResult = this.tests[n].perform();
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            ++n;
        }
        return new SimpleTestResult(true, "GOST3410/ECGOST3410: Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        GOST3410Test gOST3410Test = new GOST3410Test();
        TestResult testResult = gOST3410Test.perform();
        System.out.println(testResult.toString());
    }

    private class ParametersTest
    implements Test {
        private ParametersTest() {
        }

        public String getName() {
            return "GOST3410 Parameters";
        }

        public TestResult perform() {
            try {
                GOST3410ParameterSpec gOST3410ParameterSpec = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_B.getId());
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("GOST3410", "BC");
                keyPairGenerator.initialize((AlgorithmParameterSpec)gOST3410ParameterSpec, new SecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                Signature signature = Signature.getInstance("GOST3410", "BC");
                byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
                signature.initSign(privateKey);
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature = Signature.getInstance("GOST3410", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": GOST3410 verification failed");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString(), exception);
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class GenerationTest
    implements Test {
        private GenerationTest() {
        }

        public String getName() {
            return "GOST3410/ECGOST3410 Generation";
        }

        public TestResult perform() {
            try {
                X509EncodedKeySpec x509EncodedKeySpec;
                Signature signature = Signature.getInstance("GOST3410", "BC");
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("GOST3410", "BC");
                byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
                GOST3410ParameterSpec gOST3410ParameterSpec = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId());
                keyPairGenerator.initialize((AlgorithmParameterSpec)gOST3410ParameterSpec, new SecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                signature.initSign(privateKey);
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature = Signature.getInstance("GOST3410", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": GOST3410 verification failed");
                }
                signature = Signature.getInstance("GOST3410", "BC");
                keyPairGenerator = KeyPairGenerator.getInstance("GOST3410", "BC");
                keyPair = keyPairGenerator.generateKeyPair();
                privateKey = keyPair.getPrivate();
                publicKey = keyPair.getPublic();
                signature.initSign(privateKey);
                signature.update(byArray);
                byArray2 = signature.sign();
                signature = Signature.getInstance("GOST3410", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": GOST3410 verification failed");
                }
                KeyFactory keyFactory = KeyFactory.getInstance("GOST3410", "BC");
                GOST3410PublicKey gOST3410PublicKey = (GOST3410PublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded()));
                if (!gOST3410PublicKey.getY().equals(((GOST3410PublicKey)publicKey).getY())) {
                    return new SimpleTestResult(false, this.getName() + ": public number not decoded properly");
                }
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
                GOST3410PrivateKey gOST3410PrivateKey = (GOST3410PrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                if (!gOST3410PrivateKey.getX().equals(((GOST3410PrivateKey)privateKey).getX())) {
                    return new SimpleTestResult(false, this.getName() + ": private number not decoded properly");
                }
                signature = Signature.getInstance("ECGOST3410", "BC");
                keyPairGenerator = KeyPairGenerator.getInstance("ECGOST3410", "BC");
                BigInteger bigInteger = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
                ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
                ECParameterSpec eCParameterSpec = new ECParameterSpec((ECCurve)fp, (ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("2")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
                keyPairGenerator.initialize((AlgorithmParameterSpec)eCParameterSpec, new SecureRandom());
                keyPair = keyPairGenerator.generateKeyPair();
                privateKey = keyPair.getPrivate();
                publicKey = keyPair.getPublic();
                signature.initSign(privateKey);
                signature.update(byArray);
                byArray2 = signature.sign();
                signature = Signature.getInstance("ECGOST3410", "BC");
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": ECGOST3410 verification failed");
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString(), exception);
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class ECGOST3410Test
    implements Test {
        BigInteger r = new BigInteger("29700980915817952874371204983938256990422752107994319651632687982059210933395");
        BigInteger s = new BigInteger("46959264877825372965922731380059061821746083849389763294914877353246631700866");
        SecureRandom k = new SecureRandom(this){
            private final /* synthetic */ ECGOST3410Test this$1;
            {
                this.this$1 = eCGOST3410Test;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = new BigInteger("53854137677348463731403841147996619241504003434302020712960838528893196233395").toByteArray();
                System.arraycopy(byArray2, byArray2.length - byArray.length, byArray, 0, byArray.length);
            }
        };

        private ECGOST3410Test() {
        }

        public String getName() {
            return "ECGOST3410 Test";
        }

        public TestResult perform() {
            try {
                BigInteger bigInteger = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564821041");
                ECCurve.Fp fp = new ECCurve.Fp(bigInteger, new BigInteger("7"), new BigInteger("43308876546767276905765904595650931995942111794451039583252968842033849580414"));
                ECParameterSpec eCParameterSpec = new ECParameterSpec((ECCurve)fp, (ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("2")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("4018974056539037503335449422937059775635739389905545080690979365213431566280"))), new BigInteger("57896044618658097711785492504343953927082934583725450622380973592137631069619"));
                ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(new BigInteger("55441196065363246126355624130324183196576709222340016572108097750006097525544"), eCParameterSpec);
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)new ECPoint.Fp((ECCurve)fp, (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("57520216126176808443631405023338071176630104906313632182896741342206604859403")), (ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger("17614944419213781543809391949654080031942662045363639260709847859438286763994"))), eCParameterSpec);
                Signature signature = Signature.getInstance("ECGOST3410", "BC");
                KeyFactory keyFactory = KeyFactory.getInstance("ECGOST3410", "BC");
                PrivateKey privateKey = keyFactory.generatePrivate((KeySpec)eCPrivateKeySpec);
                PublicKey publicKey = keyFactory.generatePublic((KeySpec)eCPublicKeySpec);
                signature.initSign(privateKey, this.k);
                byte[] byArray = new byte[]{97, 98, 99};
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                signature.initVerify(publicKey);
                signature.update(byArray);
                if (!signature.verify(byArray2)) {
                    return new SimpleTestResult(false, this.getName() + ": ECGOST3410 verification failed");
                }
                BigInteger[] bigIntegerArray = GOST3410Test.this.decode(byArray2);
                if (!this.r.equals(bigIntegerArray[0])) {
                    return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + this.r + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
                }
                if (!this.s.equals(bigIntegerArray[1])) {
                    return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + this.s + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
                }
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString(), exception);
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }
}

