/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS10CertRequestTest
implements Test {
    private byte[] gost3410EC_A = Base64.decode((String)"MIIBOzCB6wIBADB/MQ0wCwYDVQQDEwR0ZXN0MRUwEwYDVQQKEwxEZW1vcyBDbyBMdGQxHjAcBgNVBAsTFUNyeXB0b2dyYXBoeSBkaXZpc2lvbjEPMA0GA1UEBxMGTW9zY293MQswCQYDVQQGEwJydTEZMBcGCSqGSIb3DQEJARYKc2RiQGRvbC5ydTBjMBwGBiqFAwICEzASBgcqhQMCAiMBBgcqhQMCAh4BA0MABEBYx0P2D7YuuZo5HgdIAUKAXcLBDZ+4LYFgbKjrfStVfH59lc40BQ2FZ7M703hLpXK8GiBQGEYpKaAuQZnMIpByoAAwCAYGKoUDAgIDA0EAgXMcTrhdOY2Er2tHOSAgnMezqrYxocZTWhxmW5RlJY6lbXH5rndCn4swFzXU+YhgAsJv1wQBaoZEWRl5WV4/nA==");
    private byte[] gost3410EC_B = Base64.decode((String)"MIIBPTCB7QIBADCBgDENMAsGA1UEAxMEdGVzdDEWMBQGA1UEChMNRGVtb3MgQ28gTHRkLjEeMBwGA1UECxMVQ3J5cHRvZ3JhcGh5IGRpdmlzaW9uMQ8wDQYDVQQHEwZNb3Njb3cxCzAJBgNVBAYTAnJ1MRkwFwYJKoZIhvcNAQkBFgpzZGJAZG9sLnJ1MGMwHAYGKoUDAgITMBIGByqFAwICIwIGByqFAwICHgEDQwAEQI5SLoWT7dZVilbV9j5B/fyIDuDs6x4pjqNC2TtFYbpRHrk/Wc5g/mcHvD80tsm5o1C77cizNzkvAVUM4VT4Dz6gADAIBgYqhQMCAgMDQQAoT5TwJ8o+bSrxckymyo3diwG7ZbSytX4sRiKywXPWRS9LlBvPO2NqwpS2HUnxSU8rzfL9fJcybATf7Yt1OEVq");
    private byte[] gost3410EC_C = Base64.decode((String)"MIIBRDCB9AIBADCBhzEVMBMGA1UEAxMMdGVzdCByZXF1ZXN0MRUwEwYDVQQKEwxEZW1vcyBDbyBMdGQxHjAcBgNVBAsTFUNyeXB0b2dyYXBoeSBkaXZpc2lvbjEPMA0GA1UEBxMGTW9zY293MQswCQYDVQQGEwJydTEZMBcGCSqGSIb3DQEJARYKc2RiQGRvbC5ydTBjMBwGBiqFAwICEzASBgcqhQMCAiMDBgcqhQMCAh4BA0MABEBcmGh7OmR4iqqj+ycYo1S1fS7r5PhisSQU2Ezuz8wmmmR2zeTZkdMYCOBaUTMNms0msW3wuYDho7nTDNscHTB5oAAwCAYGKoUDAgIDA0EAVoOMbfyo1Un4Ss7WQrUjHJoiaYW8Ime5LeGGU2iW3ieAv6es/FdMrwTKkqn5dhd3aL/itFg5oQbhyfXw5yw/QQ==");
    private byte[] gost3410EC_ExA = Base64.decode((String)"MIIBOzCB6wIBADB/MQ0wCwYDVQQDEwR0ZXN0MRUwEwYDVQQKEwxEZW1vcyBDbyBMdGQxHjAcBgNVBAsTFUNyeXB0b2dyYXBoeSBkaXZpc2lvbjEPMA0GA1UEBxMGTW9zY293MQswCQYDVQQGEwJydTEZMBcGCSqGSIb3DQEJARYKc2RiQGRvbC5ydTBjMBwGBiqFAwICEzASBgcqhQMCAiQABgcqhQMCAh4BA0MABEDkqNT/3f8NHj6EUiWnK4JbVZBh31bEpkwq9z3jf0u8ZndG56Vt+K1ZB6EpFxLT7hSIos0wweZ2YuTZ4w43OgodoAAwCAYGKoUDAgIDA0EASk/IUXWxoi6NtcUGVF23VRV1L3undB4sRZLp4VhogQ7m3CMbZFfJ2cPu6QyarseXGYHmazoirH5lGjEo535c1g==");
    private byte[] gost3410EC_ExB = Base64.decode((String)"MIIBPTCB7QIBADCBgDENMAsGA1UEAxMEdGVzdDEWMBQGA1UEChMNRGVtb3MgQ28gTHRkLjEeMBwGA1UECxMVQ3J5cHRvZ3JhcGh5IGRpdmlzaW9uMQ8wDQYDVQQHEwZNb3Njb3cxCzAJBgNVBAYTAnJ1MRkwFwYJKoZIhvcNAQkBFgpzZGJAZG9sLnJ1MGMwHAYGKoUDAgITMBIGByqFAwICJAEGByqFAwICHgEDQwAEQMBWYUKPy/1Kxad9ChAmgoSWSYOQxRnXo7KEGLU5RNSXA4qMUvArWzvhav+EYUfTbWLh09nELDyHt2XQcvgQHnSgADAIBgYqhQMCAgMDQQAdaNhgH/ElHp64mbMaEo1tPCg9Q22McxpH8rCzE0QBpF4H5mSSQVGI5OAXHToetnNuh7gHHSynyCupYDEHTbkZ");

    public String getName() {
        return "PKCS10CertRequest";
    }

    public TestResult perform() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(512);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
            hashtable.put(X509Name.C, "AU");
            hashtable.put(X509Name.O, "The Legion of the Bouncy Castle");
            hashtable.put(X509Name.L, "Melbourne");
            hashtable.put(X509Name.ST, "Victoria");
            hashtable.put(X509Name.EmailAddress, "feedback-crypto@bouncycastle.org");
            X509Name x509Name = new X509Name(hashtable);
            PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest("SHA1withRSA", x509Name, keyPair.getPublic(), null, keyPair.getPrivate());
            byte[] byArray = pKCS10CertificationRequest.getEncoded();
            PKCS10CertificationRequest pKCS10CertificationRequest2 = new PKCS10CertificationRequest(byArray);
            if (!pKCS10CertificationRequest2.verify()) {
                return new SimpleTestResult(false, this.getName() + ": Failed verify check.");
            }
            if (!pKCS10CertificationRequest2.getPublicKey().equals(pKCS10CertificationRequest.getPublicKey())) {
                return new SimpleTestResult(false, this.getName() + ": Failed public key check.");
            }
            PKCS10CertificationRequest pKCS10CertificationRequest3 = new PKCS10CertificationRequest(this.gost3410EC_A);
            if (!pKCS10CertificationRequest3.verify()) {
                System.out.println(new SimpleTestResult(false, this.getName() + ": Failed verify check gost3410EC_A."));
            }
            if (!(pKCS10CertificationRequest3 = new PKCS10CertificationRequest(this.gost3410EC_B)).verify()) {
                return new SimpleTestResult(false, this.getName() + ": Failed verify check gost3410EC_B.");
            }
            pKCS10CertificationRequest3 = new PKCS10CertificationRequest(this.gost3410EC_C);
            if (!pKCS10CertificationRequest3.verify()) {
                return new SimpleTestResult(false, this.getName() + ": Failed verify check gost3410EC_C.");
            }
            pKCS10CertificationRequest3 = new PKCS10CertificationRequest(this.gost3410EC_ExA);
            if (!pKCS10CertificationRequest3.verify()) {
                return new SimpleTestResult(false, this.getName() + ": Failed verify check gost3410EC_ExA.");
            }
            pKCS10CertificationRequest3 = new PKCS10CertificationRequest(this.gost3410EC_ExB);
            if (!pKCS10CertificationRequest3.verify()) {
                return new SimpleTestResult(false, this.getName() + ": Failed verify check gost3410EC_ExA.");
            }
            KeyPairGenerator keyPairGenerator2 = KeyPairGenerator.getInstance("ECDSA", "BC");
            ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
            ECParameterSpec eCParameterSpec = new ECParameterSpec((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
            keyPairGenerator2.initialize((AlgorithmParameterSpec)eCParameterSpec, new SecureRandom());
            keyPair = keyPairGenerator2.generateKeyPair();
            pKCS10CertificationRequest3 = new PKCS10CertificationRequest("ECDSAWITHSHA1", new X509Name("CN=XXX"), keyPair.getPublic(), null, keyPair.getPrivate());
            if (!pKCS10CertificationRequest3.verify()) {
                return new SimpleTestResult(false, this.getName() + ": Failed verify check EC.");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString(), exception);
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PKCS10CertRequestTest pKCS10CertRequestTest = new PKCS10CertRequestTest();
        TestResult testResult = pKCS10CertRequestTest.perform();
        System.out.println(testResult.toString());
    }
}

