/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.SecretKey;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.test.CMSTestUtil;

public class EnvelopedDataTest
extends TestCase {
    public boolean DEBUG = true;

    public EnvelopedDataTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(EnvelopedDataTest.class);
    }

    public static Test suite() {
        return new TestSuite(EnvelopedDataTest.class);
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testKeyTrans() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testKeyTransAES128() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES128_CBC, "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testKeyTransAES192() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate2);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES192_CBC, "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES192_CBC);
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)PKCSObjectIdentifiers.rsaEncryption.getId());
                byte[] byArray2 = recipientInformation.getContent(keyPair2.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testKeyTransAES256() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES256_CBC, "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"2.16.840.1.101.3.4.1.42");
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testKeyTransRC4() {
        try {
            byte[] byArray = "WallaWallaBouncyCastle".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.4", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.4");
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testKeyTrans128RC4() {
        try {
            byte[] byArray = "WallaWallaBouncyCastle".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate((CMSProcessable)new CMSProcessableByteArray(byArray), "1.2.840.113549.3.4", 128, "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.4");
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testKeyTransODES() {
        try {
            byte[] byArray = "WallaWallaBouncyCastle".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.3.14.3.2.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.3.14.3.2.7");
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testKeyTransSmallAES() {
        try {
            byte[] byArray = new byte[]{0, 1, 2, 3};
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), CMSEnvelopedDataGenerator.AES128_CBC, "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)CMSEnvelopedDataGenerator.AES128_CBC);
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testDESKEK() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            SecretKey secretKey = CMSTestUtil.makeDesede192Key();
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
            cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)"1.2.840.113549.1.9.16.3.6");
                byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testAESKEK() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            SecretKey secretKey = CMSTestUtil.makeAES192Key();
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
            cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
            Collection collection = recipientInformationStore.getRecipients();
            for (RecipientInformation recipientInformation : collection) {
                EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)"2.16.840.1.101.3.4.1.25");
                byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }

    public void testRC2KEK() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            SecretKey secretKey = CMSTestUtil.makeRC2128Key();
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
            cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            Iterator iterator = collection.iterator();
            EnvelopedDataTest.assertEquals((String)cMSEnvelopedData.getEncryptionAlgOID(), (String)"1.2.840.113549.3.7");
            while (iterator.hasNext()) {
                RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                EnvelopedDataTest.assertEquals((String)recipientInformation.getKeyEncryptionAlgOID(), (String)"1.2.840.113549.1.9.16.3.7");
                byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
                EnvelopedDataTest.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            EnvelopedDataTest.fail();
        }
    }
}

