/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.interfaces.GOST3410PrivateKey;

public class CMSSignedDataGenerator {
    CertStore certStore;
    ArrayList certs = new ArrayList();
    ArrayList crls = new ArrayList();
    ArrayList signerInfs = new ArrayList();
    ArrayList signers = new ArrayList();
    public static final String DATA = PKCSObjectIdentifiers.data.getId();
    public static final String DIGEST_SHA1 = "1.3.14.3.2.26";
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_MD5 = "1.2.840.113549.2.5";
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String ENCRYPTION_RSA = "1.2.840.113549.1.1.1";
    public static final String ENCRYPTION_DSA = "1.2.840.10040.4.3";
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();

    private String getEncOID(PrivateKey privateKey, String string) {
        String string2 = null;
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_RSA;
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_DSA;
            if (!string.equals(DIGEST_SHA1)) {
                throw new IllegalArgumentException("can't mix DSA with anything but SHA1");
            }
        } else if (privateKey instanceof GOST3410PrivateKey || "GOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_GOST3410;
        } else if ("ECGOST3410".equalsIgnoreCase(privateKey.getAlgorithm())) {
            string2 = ENCRYPTION_ECGOST3410;
        }
        return string2;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2, attributeTable, attributeTable2));
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this.signers.add(iterator.next());
        }
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        X509Extension x509Extension;
        Iterator iterator;
        try {
            iterator = certStore.getCertificates(null).iterator();
            while (iterator.hasNext()) {
                x509Extension = (X509Certificate)iterator.next();
                this.certs.add(new X509CertificateStructure((ASN1Sequence)this.makeObj(((Certificate)((Object)x509Extension)).getEncoded())));
            }
        }
        catch (IOException iOException) {
            throw new CMSException("error processing certs", iOException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CMSException("error encoding certs", certificateEncodingException);
        }
        try {
            iterator = certStore.getCRLs(null).iterator();
            while (iterator.hasNext()) {
                x509Extension = (X509CRL)iterator.next();
                this.crls.add(new CertificateList((ASN1Sequence)this.makeObj(((X509CRL)x509Extension).getEncoded())));
            }
        }
        catch (IOException iOException) {
            throw new CMSException("error processing crls", iOException);
        }
        catch (CRLException cRLException) {
            throw new CMSException("error encoding crls", cRLException);
        }
    }

    private DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        return aSN1InputStream.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)this.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, false, string);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        ByteArrayOutputStream byteArrayOutputStream;
        ASN1EncodableVector aSN1EncodableVector;
        AlgorithmIdentifier algorithmIdentifier;
        Object object;
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        Iterator iterator = ((AbstractList)this.signers).iterator();
        while (iterator.hasNext()) {
            object = (SignerInformation)iterator.next();
            try {
                algorithmIdentifier = this.makeAlgId(((SignerInformation)object).getDigestAlgOID(), ((SignerInformation)object).getDigestAlgParams());
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            aSN1EncodableVector2.add((DEREncodable)algorithmIdentifier);
            aSN1EncodableVector3.add((DEREncodable)((SignerInformation)object).toSignerInfo());
        }
        iterator = ((AbstractList)this.signerInfs).iterator();
        while (iterator.hasNext()) {
            object = (SignerInf)iterator.next();
            try {
                algorithmIdentifier = this.makeAlgId(((SignerInf)object).getDigestAlgOID(), ((SignerInf)object).getDigestAlgParams());
                aSN1EncodableVector2.add((DEREncodable)algorithmIdentifier);
                aSN1EncodableVector3.add((DEREncodable)((SignerInf)object).toSignerInfo(dERObjectIdentifier, cMSProcessable, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for signature.", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("error creating signature.", signatureException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CMSException("error creating sid.", certificateEncodingException);
            }
        }
        object = null;
        if (this.certs.size() != 0) {
            algorithmIdentifier = new ASN1EncodableVector();
            iterator = ((AbstractList)this.certs).iterator();
            while (iterator.hasNext()) {
                algorithmIdentifier.add((DEREncodable)iterator.next());
            }
            object = new DERSet((DEREncodableVector)algorithmIdentifier);
        }
        algorithmIdentifier = null;
        if (this.crls.size() != 0) {
            aSN1EncodableVector = new ASN1EncodableVector();
            iterator = ((AbstractList)this.crls).iterator();
            while (iterator.hasNext()) {
                aSN1EncodableVector.add((DEREncodable)iterator.next());
            }
            algorithmIdentifier = new DERSet((DEREncodableVector)aSN1EncodableVector);
        }
        if (bl) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                cMSProcessable.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new CMSException("encapsulation error.", iOException);
            }
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
            aSN1EncodableVector = new ContentInfo(dERObjectIdentifier, (DEREncodable)bERConstructedOctetString);
        } else {
            aSN1EncodableVector = new ContentInfo(dERObjectIdentifier, null);
        }
        byteArrayOutputStream = new SignedData((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector2), (ContentInfo)aSN1EncodableVector, (ASN1Set)object, (ASN1Set)algorithmIdentifier, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector3));
        bERConstructedOctetString = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)byteArrayOutputStream);
        return new CMSSignedData(cMSProcessable, (ContentInfo)bERConstructedOctetString);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, cMSProcessable, bl, string);
    }

    private class SignerInf {
        PrivateKey key;
        X509Certificate cert;
        String digestOID;
        String encOID;
        AttributeTable sAttr;
        AttributeTable unsAttr;

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) {
            this.key = privateKey;
            this.cert = x509Certificate;
            this.digestOID = string;
            this.encOID = string2;
        }

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) {
            this.key = privateKey;
            this.cert = x509Certificate;
            this.digestOID = string;
            this.encOID = string2;
            this.sAttr = attributeTable;
            this.unsAttr = attributeTable2;
        }

        PrivateKey getKey() {
            return this.key;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        AttributeTable getSignedAttributes() {
            return this.sAttr;
        }

        AttributeTable getUnsignedAttributes() {
            return this.unsAttr;
        }

        String getDigestAlgName() {
            String string = this.getDigestAlgOID();
            if (CMSSignedDataGenerator.DIGEST_MD5.equals(string)) {
                return "MD5";
            }
            if (CMSSignedDataGenerator.DIGEST_SHA1.equals(string)) {
                return "SHA1";
            }
            if (DIGEST_SHA224.equals(string)) {
                return "SHA224";
            }
            if (DIGEST_SHA256.equals(string)) {
                return "SHA256";
            }
            if (DIGEST_SHA384.equals(string)) {
                return "SHA384";
            }
            if (DIGEST_SHA512.equals(string)) {
                return "SHA512";
            }
            if (DIGEST_GOST3411.equals(string)) {
                return "GOST3411";
            }
            return string;
        }

        String getEncryptionAlgName() {
            String string = this.getEncryptionAlgOID();
            if (CMSSignedDataGenerator.ENCRYPTION_DSA.equals(string)) {
                return "DSA";
            }
            if (CMSSignedDataGenerator.ENCRYPTION_RSA.equals(string)) {
                return "RSA";
            }
            if (ENCRYPTION_GOST3410.equals(string)) {
                return "GOST3410";
            }
            if (ENCRYPTION_ECGOST3410.equals(string)) {
                return "ECGOST3410";
            }
            return string;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, String string) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            ASN1EncodableVector aSN1EncodableVector;
            Object object;
            Object object2;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), (DEREncodable)new DERNull());
            AlgorithmIdentifier algorithmIdentifier2 = this.getEncryptionAlgOID().equals(CMSSignedDataGenerator.ENCRYPTION_DSA) ? new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID())) : new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID()), (DEREncodable)new DERNull());
            DERSet dERSet = null;
            DERSet dERSet2 = null;
            Signature signature = null;
            MessageDigest messageDigest = null;
            if (string != null) {
                signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName(), string);
                messageDigest = MessageDigest.getInstance(this.getDigestAlgName(), string);
            } else {
                signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName());
                messageDigest = MessageDigest.getInstance(this.getDigestAlgName());
            }
            cMSProcessable.write(new DigOutputStream(messageDigest));
            byte[] byArray = messageDigest.digest();
            AttributeTable attributeTable = this.getSignedAttributes();
            if (attributeTable != null) {
                object2 = new ASN1EncodableVector();
                if (attributeTable.get(CMSAttributes.contentType) == null) {
                    object2.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)dERObjectIdentifier)));
                } else {
                    object2.add((DEREncodable)attributeTable.get(CMSAttributes.contentType));
                }
                if (attributeTable.get(CMSAttributes.signingTime) == null) {
                    object2.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new Time(new Date()))));
                } else {
                    object2.add((DEREncodable)attributeTable.get(CMSAttributes.signingTime));
                }
                object2.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(byArray))));
                object = attributeTable.toHashtable();
                ((Hashtable)object).remove(CMSAttributes.contentType);
                ((Hashtable)object).remove(CMSAttributes.signingTime);
                ((Hashtable)object).remove(CMSAttributes.messageDigest);
                aSN1EncodableVector = ((Hashtable)object).values().iterator();
                while (aSN1EncodableVector.hasNext()) {
                    object2.add((DEREncodable)Attribute.getInstance(aSN1EncodableVector.next()));
                }
                dERSet = new DERSet((DEREncodableVector)object2);
            } else {
                object2 = new ASN1EncodableVector();
                object2.add((DEREncodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)dERObjectIdentifier)));
                object2.add((DEREncodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new DERUTCTime(new Date()))));
                object2.add((DEREncodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString(byArray))));
                dERSet = new DERSet((DEREncodableVector)object2);
            }
            attributeTable = this.getUnsignedAttributes();
            if (attributeTable != null) {
                object2 = attributeTable.toHashtable();
                object = ((Hashtable)object2).values().iterator();
                aSN1EncodableVector = new ASN1EncodableVector();
                while (object.hasNext()) {
                    aSN1EncodableVector.add((DEREncodable)Attribute.getInstance(object.next()));
                }
                dERSet2 = new DERSet((DEREncodableVector)aSN1EncodableVector);
            }
            object2 = new ByteArrayOutputStream();
            object = new DEROutputStream((OutputStream)object2);
            object.writeObject((Object)dERSet);
            signature.initSign(this.key);
            signature.update(((ByteArrayOutputStream)object2).toByteArray());
            aSN1EncodableVector = new DEROctetString(signature.sign());
            X509Certificate x509Certificate = this.getCertificate();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getTBSCertificate());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), algorithmIdentifier, (ASN1Set)dERSet, algorithmIdentifier2, (ASN1OctetString)aSN1EncodableVector, (ASN1Set)dERSet2);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature signature) {
            this.sig = signature;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.sig.update(byArray, n, n2);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }

        public void write(int n) throws IOException {
            try {
                this.sig.update((byte)n);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest messageDigest) {
            this.dig = messageDigest;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }
    }
}

