/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Extensions;

public class ResponseData
extends ASN1Encodable {
    private DERInteger version;
    private ResponderID responderID;
    private DERGeneralizedTime producedAt;
    private ASN1Sequence responses;
    private X509Extensions responseExtensions;

    public ResponseData(ASN1Sequence aSN1Sequence) {
        ASN1TaggedObject aSN1TaggedObject;
        int n = 0;
        this.version = aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject ? ((aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(0)).getTagNo() == 0 ? DERInteger.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), true) : null) : null;
        int n2 = ++n;
        this.responderID = ResponderID.getInstance(aSN1Sequence.getObjectAt(n2));
        int n3 = ++n;
        this.producedAt = (DERGeneralizedTime)aSN1Sequence.getObjectAt(n3);
        int n4 = ++n;
        this.responses = (ASN1Sequence)aSN1Sequence.getObjectAt(n4);
        if (aSN1Sequence.size() > ++n) {
            this.responseExtensions = X509Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n), true);
        }
    }

    public ResponseData(DERInteger dERInteger, ResponderID responderID, DERGeneralizedTime dERGeneralizedTime, ASN1Sequence aSN1Sequence, X509Extensions x509Extensions) {
        this.version = dERInteger;
        this.responderID = responderID;
        this.producedAt = dERGeneralizedTime;
        this.responses = aSN1Sequence;
        this.responseExtensions = x509Extensions;
    }

    public static ResponseData getInstance(Object object) {
        if (object == null || object instanceof ResponseData) {
            return (ResponseData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ResponseData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public static ResponseData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ResponseData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public DERGeneralizedTime getProducedAt() {
        return this.producedAt;
    }

    public ResponderID getResponderID() {
        return this.responderID;
    }

    public X509Extensions getResponseExtensions() {
        return this.responseExtensions;
    }

    public ASN1Sequence getResponses() {
        return this.responses;
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.version != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DERInteger(0)));
        }
        aSN1EncodableVector.add(this.responderID);
        aSN1EncodableVector.add(this.producedAt);
        aSN1EncodableVector.add(this.responses);
        if (this.responseExtensions != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.responseExtensions));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

