/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private Object ecSpec;
    private boolean withCompression = true;
    private GOST3410PublicKeyAlgParameters gostParams;

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    JCEECPublicKey(String string, ECPublicKey eCPublicKey) {
        this.q = eCPublicKey.getQ();
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParameters();
    }

    JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        this.ecSpec = eCPublicKeySpec.getParams();
    }

    JCEECPublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.q = eCPoint;
        this.ecSpec = eCParameterSpec;
    }

    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            ASN1OctetString aSN1OctetString;
            Object object;
            DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                object = new ASN1InputStream(dERBitString.getBytes());
                aSN1OctetString = (ASN1OctetString)((ASN1InputStream)object).readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            object = aSN1OctetString.getOctets();
            byte[] byArray = new byte[32];
            byte[] byArray2 = new byte[32];
            int n = 0;
            while (n != byArray2.length) {
                byArray[n] = (byte)object[31 - n];
                ++n;
            }
            int n2 = 0;
            while (n2 != byArray.length) {
                byArray2[n2] = (byte)object[63 - n2];
                ++n2;
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = eCNamedCurveParameterSpec;
            ECCurve.Fp fp = (ECCurve.Fp)eCNamedCurveParameterSpec.getCurve();
            this.q = new ECPoint.Fp(fp, new ECFieldElement.Fp(fp.getQ(), new BigInteger(1, byArray)), new ECFieldElement.Fp(fp.getQ(), new BigInteger(1, byArray2)));
        } else {
            Object object;
            ECCurve eCCurve;
            Object object2;
            ASN1Encodable aSN1Encodable;
            X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
                object2 = X962NamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
                this.ecSpec = new ECNamedCurveParameterSpec(X962NamedCurves.getName((DERObjectIdentifier)aSN1Encodable), ((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getG(), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH(), ((X9ECParameters)object2).getSeed());
                eCCurve = ((ECParameterSpec)this.ecSpec).getCurve();
            } else {
                aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
                this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
                eCCurve = ((ECParameterSpec)this.ecSpec).getCurve();
            }
            aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
            object2 = ((DERBitString)aSN1Encodable).getBytes();
            ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object2);
            if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
                try {
                    object = new ByteArrayInputStream((byte[])object2);
                    ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
                    aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            object = new X9ECPoint(eCCurve, aSN1OctetString);
            this.q = ((X9ECPoint)object).getPoint();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        ASN1Encodable aSN1Encodable;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            x962Parameters = new X962Parameters(X962NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()));
        } else {
            object = (ECParameterSpec)this.ecSpec;
            aSN1Encodable = new X9ECParameters(((ECParameterSpec)object).getCurve(), new ECPoint.Fp(((ECParameterSpec)object).getG().getCurve(), ((ECParameterSpec)object).getG().getX(), ((ECParameterSpec)object).getG().getY(), this.withCompression), ((ECParameterSpec)object).getN(), ((ECParameterSpec)object).getH(), ((ECParameterSpec)object).getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)aSN1Encodable);
        }
        if (this.algorithm.equals("ECGOST3410")) {
            aSN1Encodable = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(this.getQ().getCurve(), this.getQ().getX(), this.getQ().getY(), false)).getDERObject();
            BigInteger bigInteger = this.q.getX().toBigInteger();
            BigInteger bigInteger2 = this.q.getY().toBigInteger();
            byte[] byArray = new byte[64];
            byte[] byArray2 = bigInteger.toByteArray();
            int n = 0;
            while (n != 32) {
                byArray[n] = byArray2[byArray2.length - 1 - n];
                ++n;
            }
            byArray2 = bigInteger2.toByteArray();
            int n2 = 0;
            while (n2 != 32) {
                byArray[32 + n2] = byArray2[byArray2.length - 1 - n2];
                ++n2;
            }
            object = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, this.gostParams.getDERObject()), new DEROctetString(byArray));
        } else {
            aSN1Encodable = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(this.getQ().getCurve(), this.getQ().getX(), this.getQ().getY(), this.withCompression)).getDERObject();
            object = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), ((ASN1OctetString)aSN1Encodable).getOctets());
        }
        try {
            dEROutputStream.writeObject(object);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding EC public key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getFormat() {
        return "X.509";
    }

    public ECParameterSpec getParameters() {
        return (ECParameterSpec)this.ecSpec;
    }

    public ECParameterSpec getParams() {
        return (ECParameterSpec)this.ecSpec;
    }

    public ECPoint getQ() {
        return this.q;
    }

    public void setPointFormat(String string) {
        this.withCompression = "UNCOMPRESSED".equals(string) ^ true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key" + string);
        stringBuffer.append("            X: " + this.getQ().getX().toBigInteger().toString(16) + string);
        stringBuffer.append("            Y: " + this.getQ().getY().toBigInteger().toString(16) + string);
        return stringBuffer.toString();
    }
}

