/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.macs.GOST28147Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class GOST28147MacTest
implements Test {
    static byte[] gkeyBytes1 = Hex.decode((String)"6d145dc993f4019e104280df6fcd8cd8e01e101e4c113d7ec4f469ce6dcd9e49");
    static byte[] gkeyBytes2 = Hex.decode((String)"6d145dc993f4019e104280df6fcd8cd8e01e101e4c113d7ec4f469ce6dcd9e49");
    static byte[] input3 = Hex.decode((String)"7768617420646f2079612077616e7420666f72206e6f7468696e673f");
    static byte[] input4 = Hex.decode((String)"7768617420646f2079612077616e7420666f72206e6f7468696e673f");
    static byte[] output7 = Hex.decode((String)"93468a46");
    static byte[] output8 = Hex.decode((String)"93468a46");

    private boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        GOST28147Mac gOST28147Mac = new GOST28147Mac();
        KeyParameter keyParameter = new KeyParameter(gkeyBytes1);
        gOST28147Mac.init((CipherParameters)keyParameter);
        gOST28147Mac.update(input3, 0, input3.length);
        byte[] byArray = new byte[4];
        gOST28147Mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output7)) {
            return new SimpleTestResult(false, this.getName() + ": Failed test 1 - expected " + new String(Hex.encode((byte[])output7)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        keyParameter = new KeyParameter(gkeyBytes2);
        ParametersWithSBox parametersWithSBox = new ParametersWithSBox((CipherParameters)keyParameter, GOST28147Engine.getSBox((String)"E-A"));
        gOST28147Mac.init((CipherParameters)parametersWithSBox);
        gOST28147Mac.update(input4, 0, input4.length);
        byArray = new byte[4];
        gOST28147Mac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output8)) {
            return new SimpleTestResult(false, this.getName() + ": Failed test 2 - expected " + new String(Hex.encode((byte[])output8)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "GOST28147Mac";
    }

    public static void main(String[] stringArray) {
        GOST28147MacTest gOST28147MacTest = new GOST28147MacTest();
        TestResult testResult = gOST28147MacTest.perform();
        System.out.println(testResult);
    }
}

