/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;

public class PGPSecretKeyRingCollection {
    private HashMap secretRings = new HashMap();
    private ArrayList order = new ArrayList();

    public PGPSecretKeyRingCollection(InputStream inputStream) throws IOException, PGPException {
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        Object object = null;
        while ((object = pGPObjectFactory.nextObject()) != null) {
            if (!(object instanceof PGPSecretKeyRing)) {
                throw new IOException(String.valueOf(object.getClass().getName()) + " found where PGPSecretKeyRingExpected");
            }
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)object;
            Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    public PGPSecretKeyRingCollection(Collection collection) throws IOException, PGPException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    private PGPSecretKeyRingCollection(HashMap hashMap, ArrayList arrayList) {
        this.secretRings = hashMap;
        this.order = arrayList;
    }

    public PGPSecretKeyRingCollection(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public static PGPSecretKeyRingCollection addSecretKeyRing(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, PGPSecretKeyRing pGPSecretKeyRing) {
        Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
        if (pGPSecretKeyRingCollection.secretRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPSecretKeyRing> hashMap = new HashMap<Long, PGPSecretKeyRing>(pGPSecretKeyRingCollection.secretRings);
        ArrayList<Long> arrayList = new ArrayList<Long>(pGPSecretKeyRingCollection.order);
        hashMap.put(l, pGPSecretKeyRing);
        arrayList.add(l);
        return new PGPSecretKeyRingCollection(hashMap, arrayList);
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        Iterator iterator = ((AbstractList)this.order).iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)this.secretRings.get(iterator.next());
            pGPSecretKeyRing.encode(bCPGOutputStream);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public Iterator getKeyRings() {
        return this.secretRings.values().iterator();
    }

    public Iterator getKeyRings(String string) throws PGPException {
        return this.getKeyRings(string, false);
    }

    public Iterator getKeyRings(String string, boolean bl) throws PGPException {
        Iterator iterator = this.getKeyRings();
        ArrayList<PGPSecretKeyRing> arrayList = new ArrayList<PGPSecretKeyRing>();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKey().getUserIDs();
            while (iterator2.hasNext()) {
                if (bl) {
                    if (((String)iterator2.next()).indexOf(string) <= -1) continue;
                    arrayList.add(pGPSecretKeyRing);
                    continue;
                }
                if (!iterator2.next().equals(string)) continue;
                arrayList.add(pGPSecretKeyRing);
            }
        }
        return arrayList.iterator();
    }

    public PGPSecretKey getSecretKey(long l) throws PGPException {
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public PGPSecretKeyRing getSecretKeyRing(long l) throws PGPException {
        Long l2 = new Long(l);
        if (this.secretRings.containsKey(l2)) {
            return (PGPSecretKeyRing)this.secretRings.get(l2);
        }
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKeyRing;
        }
        return null;
    }

    public static PGPSecretKeyRingCollection removeSecretKeyRing(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, PGPSecretKeyRing pGPSecretKeyRing) {
        Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
        if (!pGPSecretKeyRingCollection.secretRings.containsKey(l)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap hashMap = new HashMap(pGPSecretKeyRingCollection.secretRings);
        ArrayList arrayList = new ArrayList(pGPSecretKeyRingCollection.order);
        hashMap.remove(l);
        int n = 0;
        while (n < arrayList.size()) {
            Long l2 = (Long)arrayList.get(n);
            if (l2.longValue() == l.longValue()) {
                arrayList.remove(n);
                break;
            }
            ++n;
        }
        return new PGPSecretKeyRingCollection(hashMap, arrayList);
    }

    public int size() {
        return this.order.size();
    }
}

